<?php
namespace App\EloquentFilters\CustomerClientPayment;

use Fouladgar\EloquentBuilder\Support\Foundation\Contracts\Filter;
use Illuminate\Database\Eloquent\Builder;

class BatchFilter extends Filter
{
    /**
     * Apply the condition to the query.
     *
     * @param Builder $builder
     * @param mixed $value
     *
     * @return Builder
     */
    public function apply(Builder $builder, $value): Builder
    {
        return $builder->whereHas('ClientPaymentBatch', function($query1) use($value) {
                    $query1->where('customer_client_batch_id', '=', $value); 
            });
    }
}
