<?php

namespace App\Classes;

use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Client;

class Replysms{

    protected $username;
    protected $password;
    protected $uri='http://www.mobisky.biz/api/mobisendsms.php?'; 
    protected $client;
    protected $response;


    public function __construct($username_, $password_)
    {
    $this->username = $username_;
    $this->password  = $password_;
    $this->client=null;
    $this->response=null;

    }
    /**
         * Use this function to initiate send sms.
         * @param $phone | string
         * @param $message | string
         * @return mixed|string
         */

    public function sendMessage($phone,$message,$shortcode){
        $parameters=[
            'username'=>$this->username,
            'password'=>$this->password,
            'destination'=>$phone,
            'message'=>$message,
            'shortcode'=>$shortcode,
        ];
        //create a guzzleclient
        $this->client=new Client();
        //send the message
        $this->response=$this->client->request('GET',$this->uri.http_build_query($parameters));
        $body= $this->response->getBody();
        if (strpos($body, 'Success') != false) {
            return "Sent";
        }
        else{
            return response()->json("Failed",500);
        }


    }

}