<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\Request;
use Password;
use Auth;
class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;
    
    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */
     public function try()
     {
         if($request->user_type == 'customers')
        {
           ['name' => "/customer/otp?send=new"];
        }
        else if($request->user_type == 'users')
        {
            ['name' => "/customeruser/otp?send=new"];
        }
     }
    
    
    protected function broker() {
        return Password::broker(request()->get('user_type'));
    }
    
    public function showResetForm(Request $request, $token = null) {
        return view('auth.passwords.reset')
            ->with(['token' => $token, 'email' => $request->email, 'user_type' => $request->user_type]
            );
            $user = $request->user_type;
    }
    // protected $user = "customer";
    // protected $redirectTo = '/payments';
    
}
