<?php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
?>

<?php $__env->startSection('content'); ?>
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Wallets</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="<?php echo e(route($dashboard)); ?>">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Wallet</a>
                                    </li>
                                </ul>
                        </div>
                        </div>
                        <div class="ml-md-auto py-2 py-md-0">
                        <a href="<?php echo e(route($dashboard)); ?>" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                <div id="vue-admin-user">
                                    <div class="card-body">
                                    
                                    <div class="card-title">
                                        <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                        Customer
                                        <?php else: ?>
                                        
                                        <span class="pull-left">Wallet Transactions</span>
                                        
                                         <button class="btn btn-info pull-right">Balance: Kes. <?php echo e($wallet[0]->cust_wallet_bal); ?></button>
                                        <?php endif; ?> 
                                        <a class="btn btn-info btn-sm text-white" style="margin-left:10px;" href=""><i class="fas fa-sync-alt"></i> Refresh</a>
                                    </div>
                                    
                                        <?php if($errors->any()): ?>
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                            <strong>Error! </strong>There were some errors with inputs.
                                            <ul>
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            </div>

                                        <?php endif; ?>
                                        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <div class="table-responsive">
                                        <!-- show for admin -->
                                        <?php if(Auth::user()->user_type != 'organization_user' && Auth::user()->user_type != 'organization'): ?>
                                        <?php if(!$customers->count()): ?>
                                        <?php echo $__env->make('layouts.nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                        
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Customer</th>
                                                    <th>Contact</th>
                                                    <th>Wallet Balance[Kes.]</th>
                                                    <th>Status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>Customer</th>
                                                <th>Contact</th>
                                                <th>Wallet Balance[Kes.]</th>
                                                <th>Status</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                            <td><?php echo e(ucfirst($customer->cust_name)); ?></td>
                                            <td>+254<?php echo e($customer->cust_primary_contact_type); ?></td>
                                            <td><?php if($customer->CustomerWallet): ?>
                                                <?php echo e($customer->CustomerWallet->cust_wallet_bal); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php if($customer->cust_status == 1): ?>
                                            <span class="badge badge-success">Active</span>
                                            <?php elseif($customer->cust_status == 0): ?>
                                            <span class="badge badge-danger">Inactive</span>
                                            <?php endif; ?>
                                            </td>
                                            <td>
                                            <div class="btn-group form-actions" role="group" aria-label="Actions">
                                            <a href="<?php echo e(route('wallet.show',$customer->cust_id)); ?>" class="btn btn-sm btn-success"><i class="far fa-eye"></i> View</a>
                                          <!--  
                                            <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#topupModal-<?php echo e($customer->cust_id); ?>" id="show-modal"><i class="fas fa-plus-circle"></i> Topup </button>
                                           --> </div>
                                            
                                            
                                            </td>
                                            </tr>
                                            <!-- update wallet modal -->
                                            <div class="modal fade" id="topupModal-<?php echo e($customer->cust_id); ?>" tabindex="-1" role="dialog" aria-labelledby="topup" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Topup <strong><?php echo e(ucfirst($customer->cust_name)); ?></strong></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        
                                            
                                                        <wallet_topup :walletdata="<?php echo e(json_encode($customer->CustomerWallet)); ?>"></wallet_topup>
                                                        
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /end update modal -->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                         <!-- /end show admin -->
                                         <?php endif; ?>
                                        <?php else: ?>
                                        <!-- show customer/user -->
                                        
                                        
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Transaction type</th>
                                                    <th>Amount [Kes.]</th>
                                                    <th>Reference</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>Transaction type</th>
                                                <th>Amount [Kes.]</th>
                                                <th>Reference</th>
                                                <th>Status</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            
                                            <?php $__currentLoopData = $transacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                            <td><?php echo e($transact['wallet_trans_type']); ?></td>
                                            <td><?php echo e($transact['wallet_trans_amount']); ?></td>
                                            <td><?php echo e($transact['wallet_trans_ref']); ?></td>
                                            <td><?php if($transact['wallet_trans_status'] == 0): ?>
                                                <span class="badge badge-danger">Pending</span>
                                             <?php elseif($transact['wallet_trans_status'] == 1): ?>
                                                <span class="badge badge-success">Paid</span>
                                             <?php endif; ?>
                                             </td>
                                           </tr>
                                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                          </table>
                                        
                                         <!-- /end show cust/user -->
                                         <?php endif; ?>
                                         </div>
                                         </div>
                                    </div>
                                </div>
                            </div>
                        </div>
            </div>
            </div>
        </div>
    </div>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dashmobisky/public_html/Accounts/resources/views/bmviews/wallet/index.blade.php ENDPATH**/ ?>