@extends('bmviews.layouts.admin')
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Admin</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route('admin-dashboard')}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Admin Users</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="{{route('admin-dashboard')}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <a href="{{ route('admin-user.create')}}" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Admin User</a>
                        </div>
                    </div>
                </div>
            <div id="vue-admin-user">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Admin User Details</div>
                                        <!-- check if exist -->
                                        @if(!$admins->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>ID#</th>
                                                    <th>Surname</th>
                                                    <th>Othername(s)</th>
                                                    <th>Username</th>
                                                    <th>Status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>ID#</th>
                                                <th>Surname</th>
                                                <th>Othername(s)</th>
                                                <th>Username</th>
                                                <th>Status</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($admins as $admin)
                                            <tr>
                                            <td>{{ $admin->admin_id }}</td>
                                            <td>{{ ucfirst($admin->admin_surname) }}</td>
                                            <td>{{ ucfirst($admin->admin_othername) }}</td>
                                            <td>{{ ucfirst($admin->admin_username) }}</td>
                                            <td>@if($admin->admin_status == 1)
                                            <span class="badge badge-success">Active</span>
                                            @elseif($admin->admin_status == 0)
                                            <span class="badge badge-danger">Inactive</span>
                                            @endif
                                            </td>
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <a href="{{ route('admin-user.show',$admin->admin_id)}}"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="View"><i class="far fa-eye"></i> </button>  </a>
                                            <a href="{{ route('admin-user.edit',$admin->admin_id)}}"> <button class="btn btn-primary btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="fa fa-edit"></i> </button></a>
                                            <button  @click.prevent="deleteItem('admindeletepath',{{$admin->admin_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            
                                            </form>
                                            </div>
                                            </td>
                                            </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    @endsection