<?php

namespace App\Models\fcmodels;

use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    //
    protected $connection = 'mysql_newfc';
    protected $fillable = [
        'number',
        'question',
        'type',
        'branching',
        'if',
        'next',
        'language_id',
        'survey_id',
    ];
    //rlshp
    public function questionSurvey()
    {
        return $this->belongsTo(Survey::class,'survey_id','id');
    }
    public function questionLang()
    {
        return $this->belongsTo(Language::class,'language_id','id');
    }
    public function questionOption()
    {
        return $this->hasMany(Option::class,'question_id');
    }
    public function questionResponse()
    {
        return $this->hasMany(Response::class,'question_id');
    }
    public function questionBranch()
    {
        return $this->hasMany(Branching::class,'question_id');
    }
}