<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerWalletTransaction extends Model
{
    
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    //
    protected $fillable = [
        'wallet_trans_id',
        'cust_wallet_cust_wallet_id',
        'wallet_trans_type',
        'wallet_trans_amount',
        'wallet_trans_status',
        'wallet_trans_ref',
        'wallet_trans_charge',
        'wallet_client_username', //commented incase the item is not the db not to throw an exception
        'wallet_transact_contact',
        'wallet_trans_decsription',
        'cust_client_cust_client_id',
        'is_registered'
    ];
    protected $primaryKey = 'wallet_trans_id';
    //WalletTrans<>client relationship
    public function WalletClient()
    {
        return $this->belongsTo(CustomerClient::class,'cust_client_cust_client_id','cust_client_id');
    }
    //Wallet<>wallet transactions relationship
    public function WalletTransactionWallet()
    {
        return $this->belongsTo(CustomerWallet::class,'cust_wallet_cust_wallet_id','cust_wallet_id');
    }
}
