<?php

namespace App\Http\Controllers\BundlesControllers;

use App\Http\Controllers\Controller;
use App\Models\atmodels\Airtime_group;
use App\Models\atmodels\Airtime_contact;
use App\Models\atmodels\Currency_credit;
use App\Models\atmodels\DataBundlesCredits;
use Illuminate\Http\Request;
use Auth;
use Exception;
use Hash;
use Log;
use DB;

class BundlesGroupController extends Controller
{
    //return groups view
    public function index()
    {

        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');
            $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount'); 
            $groups = Airtime_group::where('ShopID',$shop_id)->orderBy('group_id','DESC')->get();
            
            return view('bundleviews.groups.index', compact('datawallet','groups','wallet'));
        }
        else{ 
            return abort(401);
        }
    }
    public static function getGroupContactsCount($groupid){
      
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
           $customer_id=Auth::user()->userShopUser['customer_id'];
            //get the contacts with this group id
           $contacts = Airtime_contact::where('ShopID',$shop_id)->get();
           $groupes=$contacts->pluck('group_id')->toArray();
  
           $array1=[];
           $count=0;
           foreach($groupes as $grp){
             $replace1=str_replace('[','',$grp);
             $replace2=str_replace(']','',$replace1);
             //convert into array
             $new_grp=explode(",",$replace2);
             $count1=AirtimeGroupController::count_array_values($new_grp, $groupid);
             $count+=$count1;
             array_push($array1,$new_grp);
           }
           return $count; 
           
        }
        else{
            return abort(401);
        }
        
    }
    //count items in array
   public static function count_array_values($my_array, $match) 
    { 
        $count = 0; 
        
        foreach ($my_array as $key => $value) 
        { 
            if ($value == $match) 
            { 
                $count++; 
            } 
        } 
        
        return $count; 
    }


        //return groups view
        public function index1()
        {
            /*
            if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
            {
                $shop_id=Auth::user()->shop_id;
                $customer_id=Auth::user()->userShopUser['customer_id'];
                $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');
                $groups = Airtime_group::where('ShopID',$shop_id)->get();
                return view('bundleviews.groups.index1', compact('groups','wallet'));
            }
            else{
                return abort(401);
            }*/
              if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
                {
                    $shop_id=Auth::user()->shop_id;
                    $customer_id=Auth::user()->userShopUser['customer_id'];
                    $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');
                    $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount');
                    $groups = Airtime_group::where('shopid',$shop_id)->get();
                    
                    return view('bundleviews.groups.index', compact('groups','wallet','datawallet'));
                }
                else{
                    return abort(401);
                }
        }
    
        

    //return groups
    public function getGroups()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $groups = Airtime_group::where('shopid',$shop_id)->get();
            return $groups;
        }
    }

    //get contact data for edit
    public function getGroupData($id){
        $contacts = Airtime_group::where('group_id',$id)->get();
        return response()->json($contacts);
    }

    //
    public function storebundlesGroup(Request $request)
    {
        $request->validate([
            'group_name' => 'required',
        ]);
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
     
        $data = new Airtime_group();
        $data->name = $request->group_name;
        $data->description = $request->description;
        $data->customer_id = $customer_id;
        $data->ShopID = $shop_id;
        
        $data->save ();
    }

    //edit grp
    public function update(Request $request)
    {
        //
        $request->validate([
            'group_name' => 'required',
        ]);
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_group::findOrFail($request->group_id);
        $data->name = $request->group_name;
        $data->description = $request->description;
        $data->customer_id = $customer_id;

         
        $data->save ();
    }

    //delete group
    public function destroy($id)
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_group::findOrFail($id);
        $data->delete();
    }

//delete all Groups
public function destroyAllContacts()
{
    if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
    {
        $shop_id=Auth::user()->shop_id;
        $customer_id=Auth::user()->userShopUser['customer_id'];
    }
    else{
        return abort(401);
    }
    $data = Airtime_contact::where('ShopID',$shop_id)->delete();
    return redirect()->back()->with('success', 'Deleted succesfully');
    
}
//delete selected
public function destroySelectedContacts(Request $request)
{
    $id = $request->contact;
  
    if(empty($id))
    {
        return redirect()->back()->with('failure', 'Select atleast one contact');
    }
    if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
    {
        $shop_id=Auth::user()->shop_id;
        $customer_id=Auth::user()->userShopUser['customer_id'];
    }
    else{
        return abort(401);
    }
    $data = Airtime_contact::where('ShopID',$shop_id)->whereIn('contact_id',$id)->delete();
    return redirect()->back()->with('success', 'Deleted succesfully');
}

//delete selected groups
public function delselectedGroups($id){
    $contactsids=explode(',',$id);
    
    if(empty($contactsids))
    {
        return redirect()->back()->with('failure', 'Select atleast one Group');
    }
    if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
    {
        $shop_id=Auth::user()->shop_id;
        $customer_id=Auth::user()->userShopUser['customer_id'];
    }
    else{
        return abort(401);
    }
    $data = Airtime_group::wherein('group_id',$contactsids)->delete();
    $status="";
    if($data){
        return $status="success";
    }
    else{
        $status="failed";   
    }
    return $status;

}

}
