<?php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'fcviews.layouts.org';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'fcviews.layouts.user';
}
?>

<?php $__env->startSection('content'); ?>

<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Surveys</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Surveys</a>
                                    </li>
                                </ul>
                        </div></div>
                      
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <!--<div class="btn-group dropdown">-->
                            <!--    <button class="btn btn-white btn-round" type="button" data-target="#add" data-toggle="modal" id="show-modal">-->
                            <!--       <i class="fas fa-plus"></i> Create Survey-->
                            <!--    </button>-->
                            <!--</div>-->
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Surveys Details</div>
                                        <!-- check if exist -->
                                            <?php if($errors->any()): ?>
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                <strong>Error! </strong>There were some errors with inputs.
                                                <ul>
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                                </div>
                                            <?php endif; ?>
                                        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php if(!$surveys->count()): ?>
                                        <?php echo $__env->make('layouts.nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Name</th>
                                                <th>Shortcode</th>
                                                <th>Status</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                                <th>ID#</th>
                                                <th>Name</th>
                                                <th>Shortcode</th>
                                                <th>Status</th>
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            <?php $__currentLoopData = $surveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $survey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                            <td><?php echo e($survey->id); ?></td>
                                            <td><?php echo e(ucfirst($survey->name)); ?></td>
                                            <td><?php echo e($survey->shortcode); ?></td>   
                                            <td><?php if($survey->status == 1): ?>
                                                <span class="badge badge-danger">Closed</span>
                                                <?php else: ?>
                                                <span class="badge badge-success">Open</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                              <a href="<?php echo e(route('repo',$survey->id)); ?>"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="Reports"><i class="fa fa-eye"></i> Reports</button></a>
                                            </td>
                                            </tr>
                                            <!-- edit modal -->
                                            <div class="modal fade" id="edit-<?php echo e($survey->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Survey </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <edit-survey :data="<?php echo e(json_encode($survey)); ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                         
                                        <?php endif; ?>
                                    </div>
                                    <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Survey </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <create-survey/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    
<?php $__env->stopSection(); ?>

    
<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dashmobisky/public_html/Accounts/resources/views/fcviews/reports_survey/surveys.blade.php ENDPATH**/ ?>