<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//Route::get('databundlesfromairtime',[App\Http\Controllers\BundlesControllers\AirtimeBundlesTransfereController::class, 'databundlesfromairtime']);
Route::get('/', function () {
    // return view('welcome');
    return redirect('/login');
});

Route::get('/simplelogout', function(){
   Auth::logout();
        Session::flush();

        return redirect('/login');
});

Route::get('/createp',[App\Http\Controllers\HomeController::class,'createpass']);

Auth::routes();
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('landinghome');


Route::get('/myprofile', [App\Http\Controllers\MyProfileController::class, 'index'])->name('myprofile');

Route::get('/fc/{orgid}/{user}/{username}',[App\Http\Controllers\FcController::class, 'fcDetails']);

Route::get('/fc',[App\Http\Controllers\FcController::class, 'index']);
Route::group(['middleware' => ['auth.all']], function () {
  Route::get('/logout',[App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('logout');

  ///all auth routes here
// ==============SURVEY==========  //
Route::prefix('mobisurvey')->group(function () {
        //surveys
    Route::get('/survey-request',[App\Http\Controllers\FCControllers\Survey\MobiSurveyRequestController::class, 'index'])->name('mobisurvey.survey-request');
    Route::get('/survey-request/view',[App\Http\Controllers\FCControllers\Survey\MobiSurveyRequestController::class, 'view'])->name('mobisurvey.survey-request.view');
    Route::post('/survey-request',[App\Http\Controllers\FCControllers\Survey\MobiSurveyRequestController::class, 'request'])->name('mobisurvey.survey-request');
    //approve/reject survey use requests
    Route::post('/survey-approve',[App\Http\Controllers\FCControllers\Survey\MobiSurveyRequestController::class, 'surveyApprove'])->name('mobisurvey.approve-survey');
    Route::post('/survey-reject',[App\Http\Controllers\FCControllers\Survey\MobiSurveyRequestController::class, 'surveyReject'])->name('mobisurvey.reject-survey');
    Route::get('/surveys',[App\Http\Controllers\FCControllers\Survey\MobiSurveyController::class, 'index'])->name('mobisurvey.surveys');
    Route::post('/surveys/store',[App\Http\Controllers\FCControllers\Survey\MobiSurveyController::class, 'store'])->name('mobisurvey.surveys.store');
    Route::post('/surveys/update',[App\Http\Controllers\FCControllers\Survey\MobiSurveyController::class, 'update'])->name('mobisurvey.surveys.update');
    Route::get('/surveys_delete/{id}',[App\Http\Controllers\FCControllers\Survey\MobiSurveyController::class, 'destroy'])->name('mobisurvey.surveys.destroy');
    Route::get('/help/{id}',[App\Http\Controllers\FCControllers\Survey\MobiSurveyController::class, 'getHelp'])->name('mobisurvey.help');


    // Questions
    Route::get('/questions/{id}',[App\Http\Controllers\FCControllers\Survey\MobiQuestionController::class, 'index'])->name('mobisurvey.questions');
    Route::post('/questions/store',[App\Http\Controllers\FCControllers\Survey\MobiQuestionController::class, 'store'])->name('mobisurvey.questions.store');
    Route::post('/questions/update',[App\Http\Controllers\FCControllers\Survey\MobiQuestionController::class, 'update'])->name('mobisurvey.questions.update');
    Route::get('/questions_delete/{id}',[App\Http\Controllers\FCControllers\Survey\MobiQuestionController::class, 'destroy'])->name('mobisurvey.questions.delete');
    //options
    Route::get('/options/{id}',[App\Http\Controllers\FCControllers\Survey\MobiOptionController::class, 'index'])->name('mobisurvey.options');
    Route::post('/options/store',[App\Http\Controllers\FCControllers\Survey\MobiOptionController::class, 'store'])->name('mobisurvey.options.store');
    Route::post('/options/update',[App\Http\Controllers\FCControllers\Survey\MobiOptionController::class, 'update'])->name('mobisurvey.options.update');
    Route::get('/options_delete/{id}',[App\Http\Controllers\FCControllers\Survey\MobiOptionController::class, 'destroy'])->name('mobisurvey.options.delete');

    // participants
    Route::get('/participants/{id}',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'index'])->name('mobisurvey.participants');
    Route::post('/participants/store',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'store'])->name('mobisurvey.participants.store');
    Route::post('/participants/import',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'import'])->name('mobisurvey.participants.import');
    Route::post('/table/create',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'create'])->name('mobisurvey.participants.create');
    Route::post('/participants/update',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'update'])->name('mobisurvey.participants.update');
    Route::get('/participants_delete/{id}',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'delete'])->name('mobisurvey.participants.delete');

    //participants accordinig to survey
    Route::get('/completedparticipants/{id}',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'completedparticipants'])->name('mobisurvey.completedparticipants');
    Route::get('/allparticipants/{id}',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'index'])->name('mobisurvey.allparticipants');
   Route::get('/partiallycompletedparticipants/{id}',[App\Http\Controllers\FCControllers\Survey\ParticipantController::class, 'partiallycompletedparticipants'])->name('mobisurvey.partiallycompletedparticipants');
    Route::get('/participantsnotparticipated/{id}',[App\Http\Controllers\FCControllers\Survey\MobiParticipantController::class, 'participantsnotparticipated'])->name('mobisurvey.participantsnotparticipated');


    // language
    Route::get('/language/{id}',[App\Http\Controllers\FCControllers\Survey\MobiLanguageController::class, 'index'])->name('mobisurvey.language');
    Route::post('/language/store',[App\Http\Controllers\FCControllers\Survey\MobiLanguageController::class, 'store'])->name('mobisurvey.language.store');
    Route::post('/language/update',[App\Http\Controllers\FCControllers\Survey\MobiLanguageController::class, 'updatelanguage'])->name('mobisurvey.language.update');
    Route::get('/deleteLanguage/{id}',[App\Http\Controllers\FCControllers\Survey\MobiLanguageController::class, 'deleteLanguage'])->name('mobisurvey.deleteLanguage');

    //Responses
    Route::get('/responses/{id}',[App\Http\Controllers\FCControllers\Survey\MobiResponseController::class, 'index'])->name('mobisurvey.responses');
    Route::get('/responsetoquiz/{id}',[App\Http\Controllers\FCControllers\Survey\MobiResponseController::class, 'responsetoquiz'])->name('mobisurvey.responsetoquiz');

    Route::get('/responses_participant/{id}',[App\Http\Controllers\FCControllers\Survey\MobiResponseController::class, 'responses_participant'])->name('mobisurvey.responses_participant');

    Route::get('/quiz/{id}',[App\Http\Controllers\FCControllers\Survey\MobiResponseController::class, 'quiz'])->name('mobisurvey.quiz');

    Route::get('/repo/{id}',[App\Http\Controllers\FCControllers\Survey\MobiResponseReportController::class, 'repo'])->name('mobisurvey.repo');
    Route::get('/mysurveys',[App\Http\Controllers\FCControllers\Survey\MobiResponseReportController::class, 'surveys'])->name('mobisurvey.my-surveys');

    Route::get('/myaddssurveys',[App\Http\Controllers\FCControllers\Survey\SumsungSurveyController::class, 'index'])->name('mobisurvey.sumsung');
    Route::get('/validimes',[App\Http\Controllers\FCControllers\Survey\SumsungSurveyController::class, 'validimes'])->name('mobisurvey.validimes');
    Route::get('/invalidimes',[App\Http\Controllers\FCControllers\Survey\SumsungSurveyController::class, 'invalidimes'])->name('mobisurvey.invalidimes');



    //Shortcode
    Route::get('/organizationshortcode',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'index'])->name('mobisurvey.organizationshortcode');
     Route::get('/organizations/get',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'getOrganization']);
    //get departments
    Route::get('/Shortcodes/get',[App\Http\Controllers\FCControllers\Survey\MobiSurveyController::class, 'getShortcode']);

    //get data for reports survey
    Route::get('/getClosedQuiz/{id}',[App\Http\Controllers\FCControllers\Survey\MobiResponseReportController::class, 'getClosedQuiz']);
    //pdf
    Route::get('/participantresponsespdf/{id}',[App\Http\Controllers\FCControllers\PdfController::class, 'index'])->name('mobisurvey.participantresponsespdf');
    Route::get('/allparticipantresponsespdf/{id}',[App\Http\Controllers\FCControllers\PdfController::class, 'all'])->name('mobisurvey.allparticipantresponsespdf');


    //Organization short code
    Route::get('/organizationshortcode/{id}',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'index'])->name('mobisurvey.organizationshortcode');
    Route::post('/organizationshortcode/store',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'storeOrganizationshortcode'])->name('mobisurvey.organizationshortcode.storeOrganizationshortcode');
    Route::post('/organizationshortcode/update',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'update'])->name('mobisurvey.organizationshortcode.update');
    Route::get('/organizationshortcode/delete/{id}',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'destroy'])->name('mobisurvey.organizationshortcode.delete');

});
    // END SURVEY
// ====================== FC  ================================/////
// ====================== FC  ================================/////
Route::prefix('fc')->group(function () {


    Route::get('/', function () {
        return view('welcome');
    });
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    //++++++++++++++++++++ADMIN ONLY ROUTES++++++++++++++++++++++++++++++++++++//
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    //===unauthenticated===//
    Route::prefix('admin')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\AdminController::class, 'index'])->name('fc.admin-dashboard');
      Route::get('/login', [App\Http\Controllers\FCControllers\Auth\AdminLoginController::class, 'showLoginForm'])->name('admin.login');
      Route::post('/submitlogin', [App\Http\Controllers\FCControllers\Auth\AdminLoginController::class, 'login'])->name('admin.login.submit');
      Route::get('/logout', [App\Http\Controllers\FCControllers\Auth\AdminLoginController::class, 'logout'])->name('admin.logout');

          Route::post('/password/email',[App\Http\Controllers\FCControllers\Auth\AdminForgotPasswordController::class, 'sendResetLinkEmail'])->name('admin.password.email');
          Route::get('/password/reset',[App\Http\Controllers\FCControllers\Auth\AdminForgotPasswordController::class, 'showLinkRequestForm'])->name('admin.password.request');
          Route::post('/password/reset',[App\Http\Controllers\FCControllers\Auth\AdminResetPasswordController::class, 'reset']);
          Route::get('/password/reset/{token}',[App\Http\Controllers\FCControllers\Auth\AdminResetPasswordController::class, 'showResetForm'])->name('admin.password.reset');
    //===auth======//
    // Route::group(['middleware'=>'auth'],function(){

          //admin functionalities.
          Route::get('admin-user', [App\Http\Controllers\FCControllers\AdminUserController::class, 'index'])->name('fc.admin-user.index');
          Route::post('/storeAdmin', [App\Http\Controllers\FCControllers\AdminUserController::class, 'storeAdmin']);
          Route::post('/editAdmin', [App\Http\Controllers\FCControllers\AdminUserController::class, 'editAdmin']);
          Route::get('/deleteAdmin/{id}', [App\Http\Controllers\FCControllers\AdminUserController::class, 'deleteAdmin']);


    //   });
    });
    // Route::group(['middleware'=>'auth'],function(){
        Route::get('/organizations', [App\Http\Controllers\FCControllers\OrganizationController::class, 'index'])->name('organizations.index');
        Route::post('/organizations/store', [App\Http\Controllers\FCControllers\OrganizationController::class, 'store'])->name('organizations.store');
    // });
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    //++++++++++++++++++++ORG. ONLY ROUTES++++++++++++++++++++++++++++++++++++//
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    //===unauthenticated===//
     Route::prefix('organizations')->group(function () {
         Route::get('/getme',[App\Http\Controllers\FCControllers\OrganizationController::class, 'testorg']);
        //logins

        Route::get('/login', [App\Http\Controllers\FCControllers\Auth\OrganizationLoginController::class, 'showLoginForm'])->name('organization.login');
        Route::post('/submitlogin', [App\Http\Controllers\FCControllers\Auth\OrganizationLoginController::class, 'login'])->name('organization.login.submit');
        Route::get('/logout',[App\Http\Controllers\FCControllers\Auth\OrganizationLoginController::class, 'logout'])->name('organization.logout');
        Route::post('/password/email',[App\Http\Controllers\FCControllers\Auth\OrganizationForgotPasswordController::class, 'sendResetLinkEmail'])->name('customer.password.email');
        Route::get('/password/reset',[App\Http\Controllers\FCControllers\Auth\OrganizationForgotPasswordController::class, 'showLinkRequestForm'])->name('customer.password.request');
        Route::post('/password/reset',[App\Http\Controllers\FCControllers\Auth\OrganizationResetPasswordController::class, 'reset']);
        Route::get('/password/reset/{token}',[App\Http\Controllers\FCControllers\Auth\OrganizationResetPasswordController::class, 'showResetForm'])->name('customer.password.reset');

    //===auth======//
   // Route::group(['middleware'=>'auth.org'],function(){

        Route::get('/dashboard', [App\Http\Controllers\FCControllers\OrganizationController::class, 'dashboard'])->name('organization-dashboard');
        Route::post('/update', [App\Http\Controllers\FCControllers\OrganizationController::class, 'update'])->name('organizations.update');
        Route::get('/delete/{id}', [App\Http\Controllers\FCControllers\OrganizationController::class, 'delete']);

      //});
    });
    // Route::group(['middleware'=>'auth'],function(){
      // Organization user routes
    Route::prefix('organization-users')->group(function () {
        Route::get('/', [App\Http\Controllers\FCControllers\OrganizationUserController::class, 'index'])->name('organization-users.index');
        Route::post('/store', [App\Http\Controllers\FCControllers\OrganizationUserController::class, 'store'])->name('organization-users.store');
        Route::post('/update', [App\Http\Controllers\FCControllers\OrganizationUserController::class, 'update'])->name('organization-users.update');


      });
      Route::get('/orgusersdelete/{id}', [App\Http\Controllers\FCControllers\OrganizationUserController::class, 'delete']);
    // });
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    //++++++++++++++++++++USER ONLY ROUTES++++++++++++++++++++++++++++++++++++//
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    //===unauthenticated===//
    // Auth::routes();
    //===auth======//
    // Route::group(['middleware'=>'auth'],function(){
      ///
        Route::get('/home', [App\Http\Controllers\FCControllers\HomeController::class, 'index'])->name('home');
    //   });
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    //++++++++++++++++++++SHARED ROUTES++++++++++++++++++++++++++++++++++++//
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
    //===unauthenticated===//

    //===auth======//
    // Route::group(['middleware'=>['auth.admin' OR 'auth.org' OR 'auth.user']],function(){
      /////
          Route::get('/tags',[App\Http\Controllers\FCControllers\TaggedController::class, 'index'])->name('tags.index');
          Route::get('/tagged-sms/{id}',[App\Http\Controllers\FCControllers\TaggedController::class, 'tagged'])->name('tagged-sms.show');
          Route::get('/untagged',[App\Http\Controllers\FCControllers\TaggedController::class, 'untagged'])->name('untagged');
      // });





    Route::prefix('users')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\UsersControllers::class, 'index'])->name('users-dashboard');
      Route::get('/',[App\Http\Controllers\FCControllers\UsersControllers::class, 'index'])->name('users.index');
      Route::get('/show/{id}',[App\Http\Controllers\FCControllers\UsersControllers::class, 'show'])->name('users.show');
      Route::get('/create',[App\Http\Controllers\FCControllers\UsersControllers::class, 'create'])->name('users.create');



      Route::get('/store',[App\Http\Controllers\FCControllers\UsersControllers::class, 'store'])->name('users.store');
      Route::post('/edit',[App\Http\Controllers\FCControllers\UsersControllers::class, 'edit'])->name('users.edit');
      Route::get('/destroy/{id}',[App\Http\Controllers\FCControllers\UsersControllers::class, 'destroy'])->name('users.destroy');
      Route::post('/addclient',[App\Http\Controllers\FCControllers\UsersControllers::class, 'addclient']);
      Route::post('/update',[App\Http\Controllers\FCControllers\UsersControllers::class, 'update']);

    });
    //Roles routes
    Route::prefix('roles')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\RoleController::class, 'index'])->name('roles.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\RoleController::class, 'store'])->name('roles.store');
      Route::post('/update', [App\Http\Controllers\FCControllers\RoleController::class, 'update'])->name('roles.update');

      Route::get('/get', [App\Http\Controllers\FCControllers\RoleController::class, 'get']);
    });
     Route::get('/rolesdelete/{id}', [App\Http\Controllers\FCControllers\RoleController::class, 'delete']);

    Route::prefix('departments')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\DepartmentController::class, 'index'])->name('departments-dashboard');

      Route::get('/', [App\Http\Controllers\FCControllers\DepartmentController::class, 'index'])->name('departments.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\DepartmentController::class, 'store'])->name('departments.store');
      Route::post('/update', [App\Http\Controllers\FCControllers\DepartmentController::class, 'update'])->name('departments.update');
      Route::get('/delete/{id}', [App\Http\Controllers\FCControllers\DepartmentController::class, 'delete']);


      Route::post('/storeDepartment', [App\Http\Controllers\FCControllers\DepartmentController::class, 'storeDepartment']);
      Route::post('/editDepartment', [App\Http\Controllers\FCControllers\DepartmentController::class, 'editDepartment']);


      Route::get('/testdelete/{id}',[App\Http\Controllers\FCControllers\DepartmentController::class,'testId']);
       //delete department


    });

     Route::get('/deleteDepartments/{id}', [App\Http\Controllers\FCControllers\DepartmentController::class, 'deleteDepartment']);

    Route::prefix('inboxtags')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\InboxTagController::class, 'index'])->name('inboxtags-dashboard');

      Route::get('/', [App\Http\Controllers\FCControllers\InboxTagController::class, 'index'])->name('inboxtags.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\InboxTagController::class, 'store'])->name('inboxtags.store');
      Route::post('/update', [App\Http\Controllers\FCControllers\InboxTagController::class, 'update'])->name('inboxtags.update');



      Route::post('/storeInboxTag', [App\Http\Controllers\FCControllers\InboxTagController::class, 'storeInboxTag']);
      Route::post('/editInboxtag', [App\Http\Controllers\FCControllers\InboxTagController::class, 'editInboxtag']);
      Route::get('/deleteDepartment/{id}', [App\Http\Controllers\FCControllers\InboxTagController::class, 'deleteDepartment']);
    });
    Route::get('/inboxtagsdelete/{id}', [App\Http\Controllers\FCControllers\InboxTagController::class, 'deleteInboxtag']);

    //SMS Template
    Route::prefix('sms_template')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\SmsTemplateController::class, 'index'])->name('sms_template-dashboard');

      Route::get('/', [App\Http\Controllers\FCControllers\SmsTemplateController::class, 'index'])->name('sms_template.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\SmsTemplateController::class, 'store'])->name('sms_template.store');
      Route::post('/update', [App\Http\Controllers\FCControllers\SmsTemplateController::class, 'update'])->name('sms_template.update');


      Route::post('/storeSmstemplate', [App\Http\Controllers\FCControllers\SmsTemplateController::class, 'storeSmstemplate']);
      Route::post('/editInboxtag', [App\Http\Controllers\FCControllers\SmsTemplateController::class, 'editInboxtag']);
      Route::get('/deleteDepartment/{id}', [App\Http\Controllers\FCControllers\SmsTemplateController::class, 'deleteDepartment']);
    });
    Route::get('/sms_templatedelete/{id}', [App\Http\Controllers\FCControllers\SmsTemplateController::class, 'deletesms_template']);

    Route::get('/Sms_template_columns/get',[App\Http\Controllers\FCControllers\SmsTemplateController::class, 'getSms_template_columns']);

    Route::get('/Sms_temp_sms/get',[App\Http\Controllers\FCControllers\SmsTemplateController::class, 'get_temp_sms']);

    // Groups  routes
    Route::prefix('groups')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\GroupController::class, 'index'])->name('groups-dashboard');

      Route::get('/', [App\Http\Controllers\FCControllers\GroupController::class, 'index'])->name('groups.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\GroupController::class, 'store'])->name('groups.store');
      Route::post('/update', [App\Http\Controllers\FCControllers\GroupController::class, 'update'])->name('groups.update');
      Route::get('/groupDeletepath/{id}', [App\Http\Controllers\FCControllers\GroupController::class, 'delete']);


      Route::post('/storeGroup', [App\Http\Controllers\FCControllers\GroupController::class, 'storeGroup']);
      Route::post('/updateGroup', [App\Http\Controllers\FCControllers\GroupController::class, 'updateGroup']);

    });
    Route::get('/groups_deleteGroup/{id}', [App\Http\Controllers\FCControllers\GroupController::class, 'deleteGroup']);

    // Contacts  routes
    Route::prefix('contacts')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\ContactController::class, 'index'])->name('contacts-dashboard');

      Route::get('/', [App\Http\Controllers\FCControllers\ContactController::class, 'index'])->name('contacts.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\ContactController::class, 'store'])->name('contacts.store');
      Route::post('/update', [App\Http\Controllers\FCControllers\ContactController::class, 'update'])->name('contacts.update');
      Route::get('/delete/{id}', [App\Http\Controllers\FCControllers\ContactController::class, 'delete']);

      Route::post('/storeContact', [App\Http\Controllers\FCControllers\ContactController::class, 'storeContact']);
      Route::post('/editContacts', [App\Http\Controllers\FCControllers\ContactController::class, 'editContacts']);
      Route::get('/deleteContact/{id}', [App\Http\Controllers\FCControllers\ContactController::class, 'deleteContact']);
      Route::get('/deleteAllContact/{id}', [App\Http\Controllers\FCControllers\ContactController::class, 'deleteAllContact']);

      Route::post('/deleteall',[App\Http\Controllers\FCControllers\ContactController::class, 'deleteAll'])->name('contacts.deleteall');

    //   Route::delete('myproductsDeleteAll', [App\Http\Controllers\FCControllers\ProductController::class, 'deleteAll']);

    });

     Route::get('/sentsms', [App\Http\Controllers\FCControllers\SentSMSController::class, 'index'])->name('sentsms.index');
     Route::get('/get_smssent',[App\Http\Controllers\FCControllers\SentSMSController::class, 'get_smssent_Data']);

    // SMS  routes
    Route::prefix('smscomposer')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\SmsComposerController::class, 'index'])->name('smscomposer.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\SmsComposerController::class, 'store'])->name('smscomposer.store');
      Route::get('/batchimportsendsms',[App\Http\Controllers\FCControllers\SmsComposerController::class, 'sendsmsinport'])->name('batchimportsendsms');
      Route::post('/smsImport',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'smsImport'])->name('smsImport');
        Route::post('/MessageTypesmsImport',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'MessageTypesmsImport'])->name('MessageTypesmsImport');
        Route::post('/sendMessageExcel',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'sendMessageExcel'])->name('sendMessageExcel');
        Route::post('/ContactMessageTypesms',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'ContactMessageTypesms'])->name('ContactMessageTypesms');
         Route::post('/TemplatesmsImport',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'TemplatesmsImport'])->name('TemplatesmsImport');

       Route::post('/sentsms',[App\Http\Controllers\FCControllers\SmsController::class, 'index'])->name('sentsms');


    });


    // exceluploads Contacts  routes
    Route::prefix('contactsuploads')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\ExcelUploadsController::class, 'index'])->name('contactsupload.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\ExcelUploadsController::class, 'store'])->name('contactsupload.store');
      Route::post('/dashboard', [App\Http\Controllers\FCControllers\ExcelUploadsController::class, 'store'])->name('contactsupload.dashboard');
      Route::post('/batchimportcontacts',[App\Http\Controllers\FCControllers\ExcelUploadsController::class, 'import'])->name('batchimportcontacts');
      Route::post('/import/{id}',[App\Http\Controllers\FCControllers\ExcelUploadsController::class, 'import'])->name('import');


    });

    // ivrreason  routes
    Route::prefix('ivrreason')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\IvrController::class, 'index'])->name('request.index');
      Route::post('/ivrreason',[App\Http\Controllers\FCControllers\IvrController::class, 'ivrreason'])->name('ivrreason');

    });

    // Excel upload SMS  routes
    Route::prefix('exceluploads')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'index'])->name('exceluploads.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'store'])->name('exceluploads.store');
      Route::post('/dashboard', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'store'])->name('exceluploads.dashboard');
      Route::post('/batchimport',[App\Http\Controllers\FCControllers\ImportCsvController::class, 'import'])->name('batchimportsms');

    });
    ////SEND SMS
    Route::get('/test',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'test']);
    Route::post('/sms-contact',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'smsContact']);
    Route::post('/sms-group',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'smsGroup']);
    Route::post('/sms-reply',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'smsReply']);
    //////////////SEND IVR////
    Route::get('/ivr',[App\Http\Controllers\FCControllers\IvrController::class, 'sending'])->name('ivrs');
    Route::post('/ivr-contact',[App\Http\Controllers\FCControllers\IvrController::class, 'ivrContact'])->name('ivr-contact');
    Route::post('/ivr-group',[App\Http\Controllers\FCControllers\IvrController::class, 'ivrGroup'])->name('ivr-group');
    //approve/reject ivr requests
    Route::post('/ivr-approve',[App\Http\Controllers\FCControllers\IvrController::class, 'ivrApprove'])->name('approve-ivr');
    Route::post('/ivr-reject',[App\Http\Controllers\FCControllers\IvrController::class, 'ivrReject'])->name('reject-ivr');


    Route::get('/getcontacts',[App\Http\Controllers\FCControllers\ContactController::class, 'getContacts']);
    //******************************************************************************************/
     Route::get('/getAllcontacts',[App\Http\Controllers\FCControllers\ContactController::class, 'getAllContacts']);
    //******************************************************************************************/

    Route::get('/getgroups',[App\Http\Controllers\FCControllers\GroupController::class, 'getGroups']);
    // Route::get('/customer-export',[App\Http\Controllers\FCControllers\CustomerController::class, 'customerExport'])->name('customer-export');

    //get countries
    Route::get('/countries',[App\Http\Controllers\FCControllers\CountryController::class, 'index'])->name('countries.index');
    //get group
    Route::get('/group/get',[App\Http\Controllers\FCControllers\ContactController::class, 'getGroups']);

    //get departments
    Route::get('/departments/get',[App\Http\Controllers\FCControllers\InboxTagController::class, 'getDepartments']);
    //transactions\
    Route::get('/transactions',[App\Http\Controllers\FCControllers\TransactionController::class, 'index'])->name('transactions');
    Route::get('/topup',[App\Http\Controllers\FCControllers\TransactionController::class, 'topup'])->name('topup');
    //IVR
    Route::get('/ivr-request',[App\Http\Controllers\FCControllers\IvrController::class, 'index'])->name('ivr-request');
    Route::get('/ivr-requests',[App\Http\Controllers\FCControllers\IvrController::class, 'view'])->name('ivr-request.view');
    Route::post('/ivr/request',[App\Http\Controllers\FCControllers\IvrController::class, 'request'])->name('request');



    // Import  routes
    Route::prefix('imports')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'index'])->name('exceluploads-dashboard');

      Route::get('/', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'index'])->name('exceluploads.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'store'])->name('exceluploads.store');
      Route::post('/update', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'update'])->name('exceluploads.update');
      Route::get('/delete/{id}', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'delete']);

      Route::post('/storeImports', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'storeImports']);
      Route::post('/editImports', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'editImports']);

    });
    Route::get('/imports_DeleteExcelUpload/{id}', [App\Http\Controllers\FCControllers\ImportCsvController::class, 'DeleteExcelUpload']);


    // Excel upload SMS  routes
    Route::prefix('smscontactexceluploads')->group(function () {
      Route::get('/', [App\Http\Controllers\FCControllers\SmscontactexceluploadsController::class, 'index'])->name('smscontactexceluploads.index');
      Route::post('/store', [App\Http\Controllers\FCControllers\SmscontactexceluploadsController::class, 'store'])->name('smscontactexceluploads.store');
      Route::post('/dashboard', [App\Http\Controllers\FCControllers\SmscontactexceluploadsController::class, 'store'])->name('smscontactexceluploads.dashboard');
      Route::post('/batchimport',[App\Http\Controllers\FCControllers\SmscontactexceluploadsController::class, 'import'])->name('uploadsbatchimportsms');

    });

    //
    Route::get('getbardata',[App\Http\Controllers\FCControllers\OrganizationController::class, 'getdata']);
    Route::get('getalldata',[App\Http\Controllers\FCControllers\OrganizationController::class, 'getalldata']);
    Route::get('getshortcodealldata',[App\Http\Controllers\FCControllers\OrganizationController::class, 'getshortcodealldata']);
    Route::get('getivralldata',[App\Http\Controllers\FCControllers\OrganizationController::class, 'getivralldata']);

    //show customsms view
    Route::get('customsms',[App\Http\Controllers\FCControllers\CustomSMSController::class, 'index'])->name('customsms.index');
    Route::post('importcustom',[App\Http\Controllers\FCControllers\CustomSMSController::class, 'customImport'])->name('importcustom');

    //
    Route::post('submitcustommessage',[App\Http\Controllers\FCControllers\CustomSMSController::class, 'submitCustomMessage'])->name('submitcustommessage');
    Route::post('drop',[App\Http\Controllers\FCControllers\CustomSMSController::class, 'drop'])->name('drop-table');
    // =========================================================================//
    //=================================SURVEYS================================///
    //========================================================================///
    //surveys
    Route::get('/survey-request',[App\Http\Controllers\FCControllers\SurveyRequestController::class, 'index'])->name('survey-request');
    Route::get('/survey-request/view',[App\Http\Controllers\FCControllers\SurveyRequestController::class, 'view'])->name('survey-request.view');
    Route::post('/survey-request',[App\Http\Controllers\FCControllers\SurveyRequestController::class, 'request'])->name('survey-request');
    //approve/reject survey use requests
    Route::post('/survey-approve',[App\Http\Controllers\FCControllers\SurveyRequestController::class, 'surveyApprove'])->name('approve-survey');
    Route::post('/survey-reject',[App\Http\Controllers\FCControllers\SurveyRequestController::class, 'surveyReject'])->name('reject-survey');
    Route::get('/surveys',[App\Http\Controllers\FCControllers\SurveyController::class, 'index'])->name('surveys');
    Route::post('/surveys/store',[App\Http\Controllers\FCControllers\SurveyController::class, 'store'])->name('surveys.store');
    Route::post('/surveys/update',[App\Http\Controllers\FCControllers\SurveyController::class, 'update'])->name('surveys.update');
    Route::get('/surveys_delete/{id}',[App\Http\Controllers\FCControllers\SurveyController::class, 'destroy'])->name('surveys.destroy');
    Route::get('/help/{id}',[App\Http\Controllers\FCControllers\SurveyController::class, 'getHelp'])->name('help');

    // Questions
    Route::get('/questions/{id}',[App\Http\Controllers\FCControllers\QuestionController::class, 'index'])->name('questions');
    Route::post('/questions/store',[App\Http\Controllers\FCControllers\QuestionController::class, 'store'])->name('questions.store');
    Route::post('/questions/update',[App\Http\Controllers\FCControllers\QuestionController::class, 'update'])->name('questions.update');
    Route::get('/questions_delete/{id}',[App\Http\Controllers\FCControllers\QuestionController::class, 'destroy'])->name('questions.delete');
    //options
    Route::get('/options/{id}',[App\Http\Controllers\FCControllers\OptionController::class, 'index'])->name('options');
    Route::post('/options/store',[App\Http\Controllers\FCControllers\OptionController::class, 'store'])->name('options.store');
    Route::post('/options/update',[App\Http\Controllers\FCControllers\OptionController::class, 'update'])->name('options.update');
    Route::get('/options_delete/{id}',[App\Http\Controllers\FCControllers\OptionController::class, 'destroy'])->name('options.delete');

    // participants
    Route::get('/participants/{id}',[App\Http\Controllers\FCControllers\ParticipantController::class, 'index'])->name('participants');
    Route::post('/participants/store',[App\Http\Controllers\FCControllers\ParticipantController::class, 'store'])->name('participants.store');
    Route::post('/participants/import',[App\Http\Controllers\FCControllers\ParticipantController::class, 'import'])->name('participants.import');
    Route::post('/table/create',[App\Http\Controllers\FCControllers\ParticipantController::class, 'create'])->name('participants.create');
    Route::post('/participants/update',[App\Http\Controllers\FCControllers\ParticipantController::class, 'update'])->name('participants.update');
    Route::get('/participants_delete/{id}',[App\Http\Controllers\FCControllers\ParticipantController::class, 'delete'])->name('participants.delete');

    //participants accordinig to survey
    Route::get('/completedparticipants/{id}',[App\Http\Controllers\FCControllers\ParticipantController::class, 'completedparticipants'])->name('completedparticipants');
    Route::get('/allparticipants/{id}',[App\Http\Controllers\FCControllers\ParticipantController::class, 'index'])->name('allparticipants');
    Route::get('/partiallycompletedparticipants/{id}',[App\Http\Controllers\FCControllers\ParticipantController::class, 'partiallycompletedparticipants'])->name('partiallycompletedparticipants');
    Route::get('/participantsnotparticipated/{id}',[App\Http\Controllers\FCControllers\ParticipantController::class, 'participantsnotparticipated'])->name('participantsnotparticipated');


    // language
    Route::get('/language/{id}',[App\Http\Controllers\FCControllers\LanguageController::class, 'index'])->name('language');
    Route::post('/language/store',[App\Http\Controllers\FCControllers\LanguageController::class, 'store'])->name('language.store');
    Route::post('/language/update',[App\Http\Controllers\FCControllers\LanguageController::class, 'updatelanguage'])->name('language.update');
    Route::get('/deleteLanguage/{id}',[App\Http\Controllers\FCControllers\LanguageController::class, 'deleteLanguage'])->name('deleteLanguage');

    //Responses
    Route::get('/responses/{id}',[App\Http\Controllers\FCControllers\ResponseController::class, 'index'])->name('responses');
    Route::get('/responsetoquiz/{id}',[App\Http\Controllers\FCControllers\ResponseController::class, 'responsetoquiz'])->name('responsetoquiz');

    Route::get('/responses_participant/{id}',[App\Http\Controllers\FCControllers\ResponseController::class, 'responses_participant'])->name('responses_participant');

    Route::get('/quiz/{id}',[App\Http\Controllers\FCControllers\ResponseController::class, 'quiz'])->name('quiz');

    Route::get('/repo/{id}',[App\Http\Controllers\FCControllers\ResponseReportController::class, 'repo'])->name('repo');
    Route::get('/mysurveys',[App\Http\Controllers\FCControllers\ResponseReportController::class, 'surveys'])->name('my-surveys');

    //Shortcode
    Route::get('/organizationshortcode',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'index'])->name('organizationshortcode');


    Route::get('/organizations/get',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'getOrganization']);
    //get departments
    Route::get('/Shortcodes/get',[App\Http\Controllers\FCControllers\SurveyController::class, 'getShortcode']);

    //get data for reports survey
    Route::get('/getClosedQuiz/{id}',[App\Http\Controllers\FCControllers\ResponseReportController::class, 'getClosedQuiz']);
    //pdf
    Route::get('/participantresponsespdf/{id}',[App\Http\Controllers\FCControllers\PdfController::class, 'index'])->name('participantresponsespdf');
    Route::get('/allparticipantresponsespdf/{id}',[App\Http\Controllers\FCControllers\PdfController::class, 'all'])->name('allparticipantresponsespdf');


    //Organization short code
    Route::get('/organizationshortcode/{id}',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'index'])->name('organizationshortcode');
    Route::post('/organizationshortcode/store',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'storeOrganizationshortcode'])->name('organizationshortcode.storeOrganizationshortcode');
    Route::post('/organizationshortcode/update',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'update'])->name('organizationshortcode.update');
    Route::get('/organizationshortcode/delete/{id}',[App\Http\Controllers\FCControllers\OrganizationshortcodeContloller::class, 'destroy'])->name('organizationshortcode.delete');
    // schedule
    Route::get('/schedule-sms',[App\Http\Controllers\FCControllers\ScheduleSms::class, 'index'])->name('schedule.index');
    Route::post('/schedule-import',[App\Http\Controllers\FCControllers\ScheduleSms::class, 'scheduleImport'])->name('scheduleImport');
    Route::get('/deleteSchedule/{id}', 'ScheduleSms@deleteSchedule');

        //SCHEDULES
    Route::post('/schedule-contact',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'scheduleContact']);
    Route::post('/schedule-group',[App\Http\Controllers\FCControllers\BulkSmsController::class, 'scheduleGroup']);
        //reset pass
    Route::get('/pass/reset',[App\Http\Controllers\FCControllers\PasswordResetController::class, 'resetP']);

});
// ====================== END FC ================================/////
// ====================== END FC  ================================/////


// ====================== BM  ================================/////
// ====================== BM  ================================/////
Route::prefix('bmp')->group(function () {
    // Route::get('/', [App\Http\Controllers\BMControllers\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/user/submitlogin', [App\Http\Controllers\BMControllers\Auth\LoginController::class, 'login'])->name('user.login.submit');

    //default auth
    // Auth::routes();
    ///////////////////////////CUSTOMER ROUTES/////////////////////////////////////////////////////
    //Customer
    Route::get('/customer-login', [App\Http\Controllers\BMControllers\UserController::class, 'customerLogin']);
    //customer routes with prefix
    Route::prefix('customer')->group(function () {
        Route::get('/', [App\Http\Controllers\BMControllers\CustController::class, 'index'])->name('customer-dashboard');
        Route::get('/login', [App\Http\Controllers\BMControllers\Auth\CustomerLoginController::class, 'showLoginForm'])->name('customer.login');
        Route::post('/submitlogin', [App\Http\Controllers\BMControllers\Auth\CustomerLoginController::class, 'login'])->name('customer.login.submit');
        Route::get('/logout',[App\Http\Controllers\BMControllers\Auth\CustomerLoginController::class, 'logout'])->name('customer.logout');
        Route::post('/password/email',[App\Http\Controllers\BMControllers\Auth\ForgotPasswordController::class, 'sendResetLinkEmail'])->name('customer.password.email');
        Route::get('/password/reset',[App\Http\Controllers\BMControllers\Auth\ForgotPasswordController::class, 'showLinkRequestForm'])->name('customer.password.request');
        Route::post('/password/reset',[App\Http\Controllers\BMControllers\Auth\ResetPasswordController::class, 'reset']);
        Route::get('/password/reset/{token}',[App\Http\Controllers\BMControllers\Auth\CustomerResetPasswordController::class, 'showResetForm'])->name('customer.password.reset');
      });
      Route::get('customer/otp',[App\Http\Controllers\BMControllers\CustomerOtpController::class, 'index']);
      Route::get('customeruser/otp',[App\Http\Controllers\BMControllers\CustomerOtpController::class, 'customeruserOtp']);
    //   Route::group(['middleware'=>['auth.customer' OR 'auth.customeruser']],function(){
        Route::post('customer/verifycode',[App\Http\Controllers\BMControllers\CustomerOtpController::class, 'verifyUser']);

    // });
    ///////////////////////////END OF CUSTOMER ROUTES/////////////////////////////////////////////
    /////////////////////////////////////SHARED MIDDLEWARE ROUTES ROUTES //////////////////////////

    ///////////////SHARED ROUTES ADMIN + CUSTOMER////////////////////////////////////////////
    //  Route::group(['middleware'=>['auth.admin' OR 'auth.customer']],function(){
         Route::resource('customers', 'App\Http\Controllers\BMControllers\CustomerController');
         Route::post('/customer/editCustomer',[App\Http\Controllers\BMControllers\CustomerController::class, 'update']);
                //customeruser routes
        Route::prefix('users')->group(function (){
            Route::get('/{id}',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'index'])->name('users.index');
            Route::get('/show/{id}',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'show'])->name('user.show');
            Route::post('/addUser',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'addUser'])->name('users.store');
            Route::get('/editUser',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'editUser'])->name('users.editUser');

            Route::get('/editUserprofile',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'editUserprofile'])->name('users.editUserprofile');

            Route::get('/deleteUser/{id}',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'deleteUser']);
           });
        Route::get('/user/create',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'create'])->name('user.create');
        Route::get('/getUser',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'getUser']);
        // /users/*all
        Route::post('/addUser',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'addUser']);
        Route::post('/editUser',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'editUser']);
        //supervision
        Route::resource('supervise','App\Http\Controllers\BMControllers\SuperviseController');
        //test
        Route::get('test-fn',[App\Http\Controllers\BMControllers\SuperviseController::class, 'testFn']);
        Route::get('test-fn2',[App\Http\Controllers\BMControllers\SuperviseController::class, 'testFn2']);
        //Route::post('/deleteUser',[App\Http\Controllers\BMControllers\CustomerUserController::class, 'deleteUser']);
        Route::get('/getUsers',[App\Http\Controllers\BMControllers\CustController::class, 'getUsers']);
        Route::get('/getActivity/{id}',[App\Http\Controllers\BMControllers\CustController::class, 'getActivity']);
        Route::get('/settings',[App\Http\Controllers\BMControllers\SettingController::class, 'index'])->name('settings.index');

    //   });
       //////////////////////////////END OF SHARED ROUTES ADMIN + CUSTOMER//////////////////////////
       /////////////////////////////shared routes admin+customer+user/////////////////////////////
    //   Route::group(['middleware'=>'auth'],function(){
            //user
            Route::prefix('user')->group(function () {
                Route::get('/groups',[App\Http\Controllers\BMControllers\GroupController::class, 'index'])->name('usergroups');
                Route::get('/clients',[App\Http\Controllers\BMControllers\ClientController::class, 'index'])->name('userclients');
                Route::get('/logoutuser',[App\Http\Controllers\BMControllers\Auth\LoginController::class, 'userLogout'])->name('user.logout');
            });
            //regenerate an otp
            Route::get('/regenerate/otp',[App\Http\Controllers\BMControllers\CustomerOtpController::class, 'codeRegenerate']);
            //admin,customer or user can add clients
            //Customer Client routes
            Route::prefix('clients')->group(function (){
                Route::get('/{id}',[App\Http\Controllers\BMControllers\ClientController::class, 'index'])->name('clients.index');
                Route::get('/show/{id}',[App\Http\Controllers\BMControllers\ClientController::class, 'show'])->name('client.show');
                Route::post('/create',[App\Http\Controllers\BMControllers\ClientController::class, 'create'])->name('client.create');
                Route::post('/store',[App\Http\Controllers\BMControllers\ClientController::class, 'store'])->name('client.store');
                Route::get('/edit/{id}',[App\Http\Controllers\BMControllers\ClientController::class, 'edit'])->name('client.edit');
                Route::get('/destroy/{id}',[App\Http\Controllers\BMControllers\ClientController::class, 'destroy'])->name('client.destroy');
                Route::post('/addclient',[App\Http\Controllers\BMControllers\ClientController::class, 'addclient']);
                Route::post('/update',[App\Http\Controllers\BMControllers\ClientController::class, 'update']);
            });
            //business number
            Route::prefix('businessbill')->group(function(){

                Route::get('/destroy/{id}',[App\Http\Controllers\BMControllers\BusinessNosController::class, 'destroy'])->name('business.destroy');
            });
            //group routes
            Route::prefix('groups')->group(function (){
                Route::get('/{id}',[App\Http\Controllers\BMControllers\GroupController::class, 'index'])->name('bmgroups.index');
                Route::get('/show/{id}',[App\Http\Controllers\BMControllers\GroupController::class, 'show']);
                Route::post('/addgroup',[App\Http\Controllers\BMControllers\GroupController::class, 'addGroup'])->name('groups.store');
                Route::get('/edit/{id}',[App\Http\Controllers\BMControllers\GroupController::class, 'edit']);
                Route::get('/delete/{id}',[App\Http\Controllers\BMControllers\GroupController::class, 'deleteGroup']);
            });
           // Route::get('auth/logout', [App\Http\Controllers\BMControllers\Auth\AuthController::class, 'logout']);

                 //Profile routes
                 Route::prefix('profile')->group(function (){

                    Route::get('/adminprofile/{id}',[App\Http\Controllers\BMControllers\ProfileController::class, 'adminprofile'])->name('profile.adminprofile');
                    Route::get('/edit/{id}',[App\Http\Controllers\BMControllers\ProfileController::class, 'adminprofile']);

                    Route::get('/customerprofile/{id}',[App\Http\Controllers\BMControllers\ProfileController::class, 'customerprofile'])->name('profile.customerprofile');
                    Route::get('/edit/{id}',[App\Http\Controllers\BMControllers\ProfileController::class, 'editcustomerprofile']);

                    Route::get('/userprofile/{id}',[App\Http\Controllers\BMControllers\ProfileController::class, 'UserProfile'])->name('profile.userprofile');

                    Route::get('/edit/{id}',[App\Http\Controllers\BMControllers\ProfileController::class, 'customeruserprofile']);
                  ;
                });

             //Logout routes
             Route::prefix('getLogout')->group(function (){

             Route::get('/getLogout',[App\Http\Controllers\BMControllers\LogoutController::class, 'getLogout']);
              ;
            });

           // Route::get('auth/logout', [App\Http\Controllers\BMControllers\Auth\AuthController::class, 'logout']);
                 //History routes
                 Route::prefix('history')->group(function (){
                    Route::get('/{id}',[App\Http\Controllers\BMControllers\HistoryController::class, 'index'])->name('history.index');

                });
            Route::get('/group/creategroup',[App\Http\Controllers\BMControllers\GroupController::class, 'create'])->name('groups.create');
            Route::post('/editGroup',[App\Http\Controllers\BMControllers\GroupController::class, 'editGroup']);
            Route::post('/import/{id}',[App\Http\Controllers\BMControllers\ClientController::class, 'import'])->name('import');
            Route::post('/batchimport/{id}',[App\Http\Controllers\BMControllers\ClientBatchController::class, 'import'])->name('batchimport');
            Route::resource('client-groups', 'App\Http\Controllers\BMControllers\ClientGroupController');
            Route::post('/vueTopup',[App\Http\Controllers\BMControllers\WalletController::class, 'vueTopup']);
            Route::resource('payments', 'App\Http\Controllers\BMControllers\PaymentController');
            Route::get('/getMyClients',[App\Http\Controllers\BMControllers\PaymentController::class, 'getMyClients']);

            ///************************************************************///
            Route::get('/getAllClients',[App\Http\Controllers\BMControllers\PaymentController::class, 'getAllClients']);

            ///**********************************************************//
            Route::post('/payments',[App\Http\Controllers\BMControllers\PaymentController::class, 'index'])->name('payments.index');
            Route::get('/getMyGroups',[App\Http\Controllers\BMControllers\PaymentController::class, 'getMyGroups']);
            Route::get('/getMyPaybills',[App\Http\Controllers\BMControllers\PaymentController::class, 'getMyPaybills']);
            Route::resource('wallet', 'App\Http\Controllers\BMControllers\WalletController');

        //   });
        /////////////////////////////END OF SHARED MIDDDLEWARE ROUTES////////////////////////////////////
        //////////////////////////////////////////ADMIN ROUTES////////////////////////////////////////////////////////
        //ADMIN ROUTES ONLY without prefix
        //   Route::group(['middleware'=>'auth.admin'],function(){
        //vue wallet topup
        Route::get('/rates',[App\Http\Controllers\BMControllers\RateController::class, 'index'])->name('rates.index');
        //client group routes
        Route::prefix('clientsgroups')->group(function (){
            Route::get('/{id}',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'index'])->name('clientgroups.index');
            Route::get('/show/{id}',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'show'])->name('clientsgroups.show');
            Route::post('/create',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'create'])->name('clientsgroups.create');
            Route::post('/store',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'store'])->name('clientsgroups.store');
            Route::get('/edit/{id}',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'edit'])->name('clientsgroups.edit');
            Route::get('/destroy/{id}',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'destroy'])->name('clientsgroups.destroy');
            Route::post('/addclientgroup',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'addclientgroup']);
            Route::post('/update',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'update']);
        });
       //client grouping get data for select
        Route::get('/getClients',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'getClients']);
        Route::get('/getGroups',[App\Http\Controllers\BMControllers\ClientGroupController::class, 'getGroups']);
        //admin routes
        Route::prefix('admin')->group(function () {
                Route::get('/', [App\Http\Controllers\BMControllers\AdminController::class, 'index'])->name('admin-dashboard');
                Route::get('/login', [App\Http\Controllers\BMControllers\Auth\AdminLoginController::class, 'showLoginForm'])->name('admin.login');
                Route::post('/submitlogin', [App\Http\Controllers\BMControllers\Auth\AdminLoginController::class, 'login'])->name('admin.login.submit');
                Route::get('/logoutadmin',[App\Http\Controllers\BMControllers\Auth\AdminLoginController::class, 'logout'])->name('admin.logout');
                //Route::group(['middleware'=>'auth.admin'],function(){
                //admin password reset routes
                Route::post('/password/email',[App\Http\Controllers\BMControllers\Auth\AdminForgotPasswordController::class, 'sendResetLinkEmail'])->name('admin.password.email');
                Route::get('/password/reset',[App\Http\Controllers\BMControllers\Auth\AdminForgotPasswordController::class, 'showLinkRequestForm'])->name('admin.password.request');
                Route::post('/password/reset',[App\Http\Controllers\BMControllers\Auth\AdminResetPasswordController::class, 'reset']);
                Route::get('/password/reset/{token}',[App\Http\Controllers\BMControllers\Auth\AdminResetPasswordController::class, 'showResetForm'])->name('admin.password.reset');
                //admin functionalities.
                Route::resource('admin-user', 'App\Http\Controllers\BMControllers\AdminUserController');
                //vue post
                Route::post('/storeAdmin',[App\Http\Controllers\BMControllers\AdminUserController::class, 'storeAdmin']);
                Route::post('/editAdmin',[App\Http\Controllers\BMControllers\AdminUserController::class, 'editAdmin']);
                Route::get('/deleteAdmin/{id}',[App\Http\Controllers\BMControllers\AdminUserController::class, 'deleteAdmin']);
                Route::get('/getAdmin',[App\Http\Controllers\BMControllers\AdminUserController::class, 'getAdmin']);
                Route::get('/getCustomers',[App\Http\Controllers\BMControllers\AdminController::class, 'getCustomers']);
                Route::get('/getUsers/{id}',[App\Http\Controllers\BMControllers\AdminController::class, 'getUsers']);
                Route::get('/getClients/{id}',[App\Http\Controllers\BMControllers\AdminController::class, 'getClients']);
                Route::get('/getBatches/{id}',[App\Http\Controllers\BMControllers\AdminController::class, 'getBatches']);
                Route::post('/addCustomer',[App\Http\Controllers\BMControllers\CustomerController::class, 'addCustomer']);
                Route::post('/editCustomer',[App\Http\Controllers\BMControllers\CustomerController::class, 'update']);
                Route::post('/vueTopup',[App\Http\Controllers\BMControllers\WalletController::class, 'vueTopup']);
            // });


    });

    // Route::group(['middleware' => 'prevent-back-history'],function(){
    //     Auth::routes();
    //     Route::get('/home', [App\Http\Controllers\BMControllers\HomeController::class, 'index']);
    //   });


    //   Route::group(['middleware' => 'preventbackbutton'],function(){
    //     Auth::routes();
    //     Route::get('/home', [App\Http\Controllers\BMControllers\HomeController::class, 'index']);
    //   });

    // Route::group(['middleware' => 'preventBackHistory'], function()
    // {
    //      Route::get('dashboard', [App\Http\Controllers\BMControllers\DashboardController::class, 'dashboard']);

    // });
    Route::get('/customer-export',[App\Http\Controllers\BMControllers\CustomerController::class, 'customerExport'])->name('customer-export');
    /////////////////////////////////////////////////END OF ADMIN ROUTES///////////////////////////////////////////
    //////////////////////////////////////////CUSTOMER ROUTES///////////////////////////////////////////////////

      //////////////////////////////////USER MIDDLEWARE ROUTES///////////////////////////////////////////
        //user
        Route::get('/user-login', [App\Http\Controllers\BMControllers\UserController::class, 'userLogin']);
        Route::group(['middleware'=>'web'],function(){
            Route::prefix('user')->group(function () {
                Route::get('/', [App\Http\Controllers\BMControllers\UserController::class, 'user'])->name('user-dashboard');
                Route::get('/groups',[App\Http\Controllers\BMControllers\GroupController::class, 'index'])->name('usergroups');
                Route::get('/clients',[App\Http\Controllers\BMControllers\ClientController::class, 'index'])->name('userclients');
                Route::get('/batch',[App\Http\Controllers\BMControllers\ClientBatchController::class, 'index'])->name('batch.index');
                Route::get('/getBatch',[App\Http\Controllers\BMControllers\ClientBatchController::class, 'getBatch'])->name('batch.getBatch');
                Route::post('/store',[App\Http\Controllers\BMControllers\ClientBatchController::class, 'store'])->name('batch.store');
                Route::post('/update',[App\Http\Controllers\BMControllers\ClientBatchController::class, 'update'])->name('batch.update');
                Route::post('/payclient',[App\Http\Controllers\BMControllers\PaymentController::class, 'payClient'])->name('user.payclient');
                Route::post('/paybusiness',[App\Http\Controllers\BMControllers\PaymentController::class, 'payBusiness'])->name('user.paybusiness');
                Route::post('/editpayclient',[App\Http\Controllers\BMControllers\PaymentController::class, 'editPayClient'])->name('user.editpayclient');
                Route::post('/paygroup',[App\Http\Controllers\BMControllers\PaymentController::class, 'payGroup'])->name('user.paygroup');
                Route::post('/paybatch',[App\Http\Controllers\BMControllers\ClientBatchController::class, 'payBatch'])->name('user.paybatch');
                Route::get('/destroy/{id}',[App\Http\Controllers\BMControllers\ClientBatchController::class, 'destroy'])->name('batch.destroy');
                Route::get('/rejectpayment/{id}',[App\Http\Controllers\BMControllers\PaymentController::class, 'rejectPayment'])->name('user.rejectpayment');
                Route::get('/retrypayment/{id}',[App\Http\Controllers\BMControllers\PaymentController::class, 'retryPayment'])->name('user.retrypayment');
                Route::get('/destroypayment/{id}',[App\Http\Controllers\BMControllers\PaymentController::class, 'destroyPayment'])->name('user.destroypayment');
            });
        });
    //////////////////////////////END OF USER MIDDLEWARE ROUTES////////////////////////////////////
    /////////////////OTHER ROUTES///////////////////////////////////////
    //Business Numbers
    Route::get('/business-numbers/{id}',[App\Http\Controllers\BMControllers\BusinessNosController::class, 'index'])->name('business-numbers');
    Route::post('/business-numbers/store',[App\Http\Controllers\BMControllers\BusinessNosController::class, 'store'])->name('business-numbers.store');
    Route::post('/business-numbers/update',[App\Http\Controllers\BMControllers\BusinessNosController::class, 'update'])->name('business-numbers.update');

    //get transactions from another database
    Route::get('/allmpesa',[App\Http\Controllers\BMControllers\MpesaController::class, 'testConnection']);
    Route::get('/specificmpesa',[App\Http\Controllers\BMControllers\MpesaController::class, 'testAllUsernames']);
    //b2c mpesa transaction
    Route::get('/b2cmpesa',[App\Http\Controllers\BMControllers\SuperviseController::class, 'b2cMpesa']);

    //b2b test
    Route::get('/b2bmpesa',[App\Http\Controllers\BMControllers\SuperviseController::class, 'b2bMpesa']);
    //b2c route
    Route::get('/b2c_setting',[App\Http\Controllers\BMControllers\ServiceCredentialController::class, 'b2cSettings']);
    //africas talking route
    Route::get('/send_sms',[App\Http\Controllers\BMControllers\MpesaController::class, 'testAfrica']);
    //////////////////////////////////////////////C2B ROUTES/////////////////
    //register c2b urls
    Route::any('c2b_register',[App\Http\Controllers\BMControllers\MpesaController::class, 'registerC2B']);
    //simulate c2b
    Route::get('/c2bmpesa',[App\Http\Controllers\BMControllers\MpesaController::class, 'c2bMpesa']);


    // Route::group(['middleware' => 'prevent-back-history'],function(){

    // 	Auth::routes();

    	Route::get('/home', [App\Http\Controllers\BMControllers\HomeController::class, 'index']);

    // });

    //mpesa routes test
    Route::get('b2btest',[App\Http\Controllers\BMControllers\SuperviseController::class, 'testMpesa']);
    Route::get('b2ctest',[App\Http\Controllers\BMControllers\SuperviseController::class, 'testB2CCode']);
    Route::get('reversaltest',[App\Http\Controllers\BMControllers\SuperviseController::class, 'reversalTest']);
    Route::get('statustest',[App\Http\Controllers\BMControllers\SuperviseController::class, 'checkStatus']);

    Route::get('encrypt',[App\Http\Controllers\BMControllers\SuperviseController::class, 'getEncryption']);
    Route::get('/monthly/{id}',[App\Http\Controllers\BMControllers\MonthlyReportController::class, 'view']);

    ////////////////////////////////////B2B TARIFFS///////////////////////////////

    Route::get('/b2btariffs',[App\Http\Controllers\BMControllers\B2BTariffController::class, 'index'])->name('b2btariffs.index');
    /////////////////////////////////////////////////////////////////////////////

    ////////////////////////////////////B2B RATES///////////////////////////////

    Route::get('/b2brates',[App\Http\Controllers\BMControllers\B2BRatesController::class, 'index'])->name('b2brates.index');
    /////////////////////////////////////////////////////////////////////////////
});
// ====================== END BM  ================================/////
// ====================== END BM  ================================/////


// ====================== START AT  ================================/////
// ====================== START AT  ================================/////

Route::prefix('at')->group(function () {

      Route::post('/testbundles',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'TestSendingBundles'])->name('testbundles');
      Route::get('/testpage1',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'showTestPage'])->name('testpage');



  //////////////////topup route////////////////////////////////////////////////////////////////
  Route::get('/topup',[App\Http\Controllers\ATControllers\CurrencyExpenditureController::class, 'topup'])->name('attopup');

  /////////////////topup transactions///////////////////////////////////////////////////////////

  Route::get('/topuptransactions',[App\Http\Controllers\ATControllers\CurrencyExpenditureController::class, 'topupTransactions'])->name('attransactions');

  /////////////////////////////test airtime////////////////////////////////////////////////////
  Route::get('/testat',[App\Http\Controllers\ATControllers\AirtimeLogController::class, 'testAiFrtime'])->name('at.test_at');
  ///////////////////////////////////////////////////////////////////////////////////////////
  //+++++++++++++++++==++++++++++customer++=++++++++++++++++//
  Route::get('/admin',[App\Http\Controllers\ATControllers\AirtimeAdminController::class, 'dashboard'])->name('at.admin-dashboard');

  //+++++++++++++++++==++++++++++customer++=++++++++++++++++//
  Route::get('/customer-dashboard',[App\Http\Controllers\ATControllers\AirtimeCustomerController::class, 'dashboard'])->name('at.customer-dashboard');

  //+++++++++++++++++==++++++++++user++=++++++++++++++++//
  Route::get('/user-dashboard',[App\Http\Controllers\ATControllers\AirtimeUserController::class, 'dashboard'])->name('at.user-dashboard');

    //Admin Users group routes
    Route::prefix('airtimeuser')->group(function (){
      Route::get('/',[App\Http\Controllers\ATControllers\AirtimeUserController::class, 'index'])->name('airtimeusers.index');
      Route::post('/storeCustomerUser', [App\Http\Controllers\ATControllers\AirtimeUserController::class, 'storeCustomerUser']);
      Route::post('/storeCustomerUser', [App\Http\Controllers\ATControllers\AirtimeUserController::class, 'storeCustomerUser']);
      Route::post('/updateCustomerUser', [App\Http\Controllers\ATControllers\AirtimeUserController::class, 'updateCustomerUser']);
      Route::get('/customeruser_delete/{id}',[App\Http\Controllers\ATControllers\AirtimeUserController::class, 'destroy'])->name('airtimeuser.destroy');

      Route::get('/show/{id}',[App\Http\Controllers\ATControllers\AirtimeUserController::class, 'show'])->name('airtimeuser.show');
      Route::post('/updateCustomerUserPassword',[App\Http\Controllers\ATControllers\AirtimeUserController::class, 'updateCustomerUserPassword'])->name('airtimeuser.updateCustomerUserPassword');
      Route::post('/addclientgroup',[App\Http\Controllers\ATControllers\AirtimeUserController::class, 'adduser']);
     });


  //+++++++++++++++++==++++++++++shared++=++++++++++++++++//
  Route::get('/groups',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'index'])->name('at.groups');
  Route::post('/groups/storeGroup',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'storeGroup'])->name('bundles.storeGroup');
  Route::post('/groups/updateGroup',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'update']);
  Route::get('/groups/delete/{id}',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'destroy']);
  Route::get('/groups/get',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'getGroups']);
  Route::get('/groups1',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'index1'])->name('at.groups1');
  Route::get('/getGroups2',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'getGroups']);
  Route::get('/groupsdata/get',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'getGroups']);
  Route::get('/group/data/{id}',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'getGroupData']);
  Route::get('/delete/group/{id}',[App\Http\Controllers\ATControllers\AirtimeGroupController::class, 'delselectedGroups']);


  Route::get('/contacts1',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'index'])->name('at.contacts1');
  ///////////////////////////////////////////test route/////////
  Route::get('/contacts',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'index1'])->name('at.contacts');
  Route::get('/getcontacts1',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'getContacts']);
  Route::get('/getgroups1',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'getGroups']);
  Route::get('/contact/data/{id}',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'getContactData']);
  Route::get('/getcontactsgroups1',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'getcontactsgroups1']);


  //////////////////////////////////////////////////////////////
  Route::post('/contacts/storeContact',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'store']);
  Route::post('/contacts/import', [App\Http\Controllers\ATControllers\AirtimeContactController::class, 'import'])->name('at.arcontacts.import');


  Route::post('/airtime/contacts/import',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'import'])->name('arcontacts.import');
  Route::post('/airtimes/contacts/import',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'import'])->name('at.arcontacts.import');



    Route::post('/contacts/updateContact',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'update']);
  Route::get('/contacts/delete/{id}',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'destroy']);
  Route::post('/contacts/deleteselected',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'destroySelectedContacts'])->name('at.contacts.deleteselected');
  Route::get('/contacts/deleteall',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'destroyAllContacts'])->name('at.contacts.deleteall');
  Route::get('/contacts/get',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'get']);
  Route::get('/contactgroup/get/{id}',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'getContactGroups']);
  Route::get('/delete/contact/{id}',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'delselectedContacts']);
  Route::get('/contactsdata/get',[App\Http\Controllers\ATControllers\AirtimeContactController::class, 'getContacts']);



  //topup
  Route::get('/topup/group',[App\Http\Controllers\ATControllers\AirtimeTopupController::class, 'group'])->name('at.topup.group');
  Route::post('/topup/groups',[App\Http\Controllers\ATControllers\AirtimeTopupController::class, 'topupGroup']);
  Route::get('/topup/contacts',[App\Http\Controllers\ATControllers\AirtimeTopupController::class, 'contact'])->name('at.topup.contact');
  Route::post('/topup/contacts',[App\Http\Controllers\ATControllers\AirtimeTopupController::class, 'topupContact']);
  Route::post('/topup/mycontacts',[App\Http\Controllers\ATControllers\AirtimeTopupController::class, 'topupMyContacts'])->name('at.topup.mycontacts');
  Route::get('/topup/myline',[App\Http\Controllers\ATControllers\AirtimeTopupController::class, 'contacttopupMyLine'])->name('at.topup.myline');
  Route::post('/topup/contactsmyline',[App\Http\Controllers\ATControllers\AirtimeTopupController::class, 'topupMyLine']);

  Route::get('/datatosendairtime/get',[App\Http\Controllers\ATControllers\AirtimeTopupController::class, 'contact'])->name('at.topup.contact');




  Route::get('/history',[App\Http\Controllers\ATControllers\AirtimeSendingRecordController::class, 'index'])->name('at.history');
  Route::get('/detailed-history',[App\Http\Controllers\ATControllers\AirtimeSendingRecordController::class, 'airtimetopupdetailedhistory']);


  Route::get('/history/excel',[App\Http\Controllers\ATControllers\AirtimeSendingRecordController::class, 'exportExcel'])->name('at.history.excel');

  Route::get('/history/create',[App\Http\Controllers\ATControllers\AirtimeSendingRecordController::class, 'showHistory']);
  Route::get('/history/pdf',[App\Http\Controllers\ATControllers\AirtimeSendingRecordController::class, 'createPDF'])->name('at.history.pdf');








  //topup Bundles
  //Route::post('/topup/mycontactsbundles',[App\Http\Controllers\BundlesControllers\AirtimeTopupController::class, 'topupMyContactsbundles'])->name('at.topup.mycontactsbundles');

  //+++++++++++++++++==++++++++++customer++=++++++++++++++++//
  Route::get('/data-customer-dashboard',[App\Http\Controllers\BundlesControllers\BundlesCustomerController::class, 'dashboard'])->name('data.customer-dashboard');

  //+++++++++++++++++==++++++++++user++=++++++++++++++++//
  Route::get('/data-user-dashboard',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'dashboard'])->name('data.user-dashboard');



  Route::post('/topup/mydatacontactsbundles',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'topupMyContactsbundles']);

  Route::get('/topup/groupbundles',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'groupbundles'])->name('data.topup.groupbundles');
  Route::post('/topup/groupsbundles',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'topupGroupbundles']);

  Route::get('/topup/contactsbundles',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'contactbundles'])->name('data.topup.contactbundles');
  Route::post('/topup/topupContactbundles',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'topupContactbundles']);

  Route::get('/topup/mylinebundles',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'mylinebundles'])->name('data.topup.mylinebundles');
  Route::post('/topup/bundlestopupMyLine',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'bundlestopupMyLine']);

  Route::get('/getdatabandlescategory/get',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'getdatabandlescategory']);
  Route::get('/getdatabandles/get/{id}',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'getdatabandles']);

  Route::get('/dataassignment',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'dataassignment'])->name('data.historybundles');


  Route::get('/data/dataassignment',[App\Http\Controllers\ATControllers\AirtimeSendingRecordController::class, 'index'])->name('data.dataassignment');

  Route::get('/datagroups',[App\Http\Controllers\BundlesControllers\BundlesGroupController::class, 'index'])->name('data.groups');
  Route::get('/datacontacts',[App\Http\Controllers\BundlesControllers\BundlesContactController::class, 'index1'])->name('data.contacts');

  //////////////////topup route////////////////////////////////////////////////////////////////
  Route::get('/bundlestopup',[App\Http\Controllers\BundlesControllers\BundlesCurrencyExpenditureController::class, 'bundlestopup'])->name('bundlestopup');

  /////////////////topup transactions///////////////////////////////////////////////////////////

  Route::get('/bundlestopuptransactions',[App\Http\Controllers\BundlesControllers\BundlesCurrencyExpenditureController::class, 'bundlestopupTransactions'])->name('bundlestransactions');
  Route::get('/bundlestopupTransactionsdata',[App\Http\Controllers\BundlesControllers\BundlesCurrencyExpenditureController::class, 'bundlestopupTransactionsdata']);


  //bundles
  /*********************************************************************************************/


  /*************************************************************************************************/
  Route::get('/activitylogs',[App\Http\Controllers\BundlesControllers\BundlesCurrencyExpenditureController::class, 'activitylogs'])->name('activitylogs');
  Route::get('/imeactivitylogs',[App\Http\Controllers\BundlesControllers\BundlesCurrencyExpenditureController::class, 'imeactivitylogs'])->name('imeactivitylogs');


  Route::get('/changepasswordarea/{email}',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'changepasswordarea'])->name('changepasswordarea');
  Route::post('/updateCustomerp',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'updateCustomerp'])->name('updateCustomerp');
  Route::get('/indexUser',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'indexUser'])->name('indexUser');
  Route::post('/updatepasswordconfirm',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'updatepasswordconfirm']);



  Route::get('/',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'index'])->name('bundlesuser.index');
  Route::get('/databalance',[App\Http\Controllers\BundlesControllers\BundlesTopupController::class, 'getdata_balance']);
  Route::post('/contacts/import',[App\Http\Controllers\BundlesControllers\BundlesContactController::class, 'import'])->name('bundles.contacts.import');
  Route::post('/bundles/contacts/import',[App\Http\Controllers\BundlesControllers\BundlesContactController::class, 'import'])->name('at.bundles.contacts.import');


  Route::post('/contacts/storebundlesContact',[App\Http\Controllers\BundlesControllers\BundlesContactController::class, 'store']);
  Route::get('/bundlescontactsdata/get',[App\Http\Controllers\BundlesControllers\BundlesContactController::class, 'getContacts']);
  Route::get('/getbundlescontacts1',[App\Http\Controllers\BundlesControllers\BundlesContactController::class, 'getContacts']);
  Route::post('/bundles/updateContact',[App\Http\Controllers\BundlesControllers\BundlesContactController::class, 'update']);

  Route::get('/tailmessages',[App\Http\Controllers\BundlesControllers\TailMessageController::class, 'index'])->name('data.tailmessages');
  Route::post('/bundles/tailmessage/storeTailMessage',[App\Http\Controllers\BundlesControllers\TailMessageController::class, 'storeTailMessage'])->name('bundles.TailMessage');
  Route::post('/bundles/updateTailMessage',[App\Http\Controllers\BundlesControllers\TailMessageController::class, 'updateTailMessage'])->name('bundles.updateTailMessage');
  Route::get('/tailmessage/delete/{id}',[App\Http\Controllers\BundlesControllers\TailMessageController::class, 'destroy'])->name('tailmessage.delete');

  //Group
  Route::post('/groups/storebundlesGroup',[App\Http\Controllers\BundlesControllers\BundlesGroupController::class, 'storebundlesGroup']);


      //Admin Users group routes
      Route::prefix('bundlesuser')->group(function (){
        Route::get('/',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'index'])->name('airtimeuser.index');
        Route::post('/storeCustomerUser', [App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'storeCustomerUser']);
        Route::post('/updateCustomerUser', [App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'updateCustomerUser']);
        Route::get('/customeruser_delete/{id}',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'destroy'])->name('airtimeuser.destroy');
        //Route::get('/bundle_users/destroy/{id}',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'destroy'])->name('bundle_users.destroy');
        Route::get('/bundle_users/destroy/{id}', [App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'destroy'])->name('bundle_users.destroy');
        Route::get('/show/{id}',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'show'])->name('airtimeuser.show');
        Route::post('/updateCustomerUserPassword',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'updateCustomerUserPassword'])->name('airtimeuser.updateCustomerUserPassword');
        Route::post('/addclientgroup',[App\Http\Controllers\BundlesControllers\BundlesUserController::class, 'adduser']);
       });
       Route::get('/bundles/history/excel',[App\Http\Controllers\BundlesControllers\BundlesReportController::class, 'exportExcel'])->name('bundles.history.excel');
       Route::get('/bundles/history/pdf',[App\Http\Controllers\BundlesControllers\BundlesReportController::class, 'createPDF'])->name('bundles.history.pdf');

       Route::get('/databundleschart/get',[App\Http\Controllers\BundlesControllers\BundlesCustomerController::class, 'databundleschart']);
       Route::get('/databundleschartdonut/get',[App\Http\Controllers\BundlesControllers\BundlesCustomerController::class, 'databundleschartdonut']);
       Route::get('getall_databundles_data',[App\Http\Controllers\BundlesControllers\BundlesCustomerController::class, 'getall_databundles_data']);
       Route::get('databundleslinechart',[App\Http\Controllers\BundlesControllers\BundlesCustomerController::class, 'databundleslinechart']);

       //test bundles


  /////////////////////////////////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////Warrant//////////////////////////////////////////////////////////////

  Route::get('/warrant-user-dashboard',[App\Http\Controllers\WarrantControllers\WarrantUserController::class, 'dashboard'])->name('warrant.user-dashboard');
  Route::get('/ime',[App\Http\Controllers\WarrantControllers\WarrantIMEController::class, 'index'])->name('warrant.imedata');

  Route::post('/warrant/ime/storeime',[App\Http\Controllers\WarrantControllers\WarrantIMEController::class, 'store']);
  Route::post('/at/ime',[App\Http\Controllers\WarrantControllers\WarrantIMEController::class, 'import'])->name('warrant.ime.import');
  Route::get('/imewarrant/delete/{id}',[App\Http\Controllers\WarrantControllers\WarrantIMEController::class, 'destroy'])->name('imeiwarrant.delete');
  Route::get('/warrant/history/excel',[App\Http\Controllers\WarrantControllers\WarrantReportController::class, 'exportExcel'])->name('warrant.history.excel');
  Route::get('/warrant/history/pdf',[App\Http\Controllers\WarrantControllers\WarrantReportController::class, 'createPDF'])->name('warrant.history.pdf');

  Route::post('/warrant/ime/updateimei',[App\Http\Controllers\WarrantControllers\WarrantIMEController::class, 'update']);


});

});
