@php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'fcviews.layouts.org';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'fcviews.layouts.user';
}
@endphp
@extends($layout)
@section('content')

<style>
.dropdown-menu a:hover{ background:#f27200;color:#fff;}
</style>


<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Contacts</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Contacts</a>
                                    </li>
                                </ul>
                        </div></div>
                      
                      
                      
                      
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>


                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="true">
                                   <i class="fas fa-plus"></i> Add Contacts
                                </button>
                                
                                
                                
                                
                                <ul class="dropdown-menu" role="menu">
                                <li>

                                <a href="#" data-toggle="modal" data-target="#add" id="show-modal" class="dropdown-item"><i class="fas fa-coins"></i> Add contacts</a>
                                <a href="#" data-toggle="modal" data-target="#importClient" id="show-modal" class="dropdown-item"><i class="fas fa-file-import"></i> Import contact</a>
                                </li>
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Contacts Details     
                                        
                                        &nbsp;  &nbsp;  &nbsp;  &nbsp;  &nbsp;  &nbsp;  &nbsp;  &nbsp;
                                          &nbsp;  &nbsp;  &nbsp;  &nbsp;  &nbsp;  &nbsp;  &nbsp;  &nbsp;
                                            @foreach($contacts as $contact)
                                             @if ($loop->first)
                                      <!--  <button  @click.prevent="deleteItem('contactDeletepathAllContacts',{{$contact->contact_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"> Delete All Contacts</i> 
                                            </button> -->
                                              @endif
                                             @endforeach
                                        </div>
                                        <!-- check if exist -->
                                        @if ($errors->any())
                                        <div class="alert alert-danger alert-dismissible" role="alert">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                        <strong>Error! </strong>There were some errors with inputs.
                                        <ul>
                                        @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                        @endforeach
                                        </ul>
                                        </div>

                                        @endif
                                        @include('layouts.messages')
                                        @if(!$contacts->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                            <form id="groups-filter-form" class="form pull-right" role="form">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <button type="submit" id="filter-submit" class="btn btn-primary btn-default btn-border" type="button">Search</button>
                                                    </div>
                                                    <input type="text" name="phone" id="filter-phone" class="form-control" placeholder="Type contact" aria-label="" aria-describedby="basic-addon1">
                                                </div>
                                                <!--<input type="text" class="form-control input-sm" name="phone" id="filter-phone">-->
                                                <!--<button type="submit" id="filter-submit" class="pull-right btn btn-primary btn-round btn-sm">-->
                                                <!--    <i class="fas fa-filter"></i>-->
                                                <!--</button>-->
                                            </form>
                                        <form action="{{ route('contacts.deleteall') }}" method="post">
                                            @csrf
                                            <button style="margin-bottom: 10px" class="btn btn-danger btn-sm delete_all">Delete Selected</button>
                                        <!-- <p>
                                            <input type="button" onclick='selectAll()' value="Select All"/>
                                            <input type="button" onclick='UnSelectAll()' value="Unselect All"/>
                                        </p> -->
                                        <!-- <input type="checkbox" name="contact" id="checkall"/>
                                        <input type="checkbox" name="contact" id="checkall"/> -->
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th><input type="checkbox" id="checkall" onclick='selectAll()' title="Select all"/></td></th>
                                                <th>ID#</th>
                                                <th>Contact Name</th>
                                                <th>Phone</th>
                                                <th>Group</th>
                                              <th class="text-center"></th>
                                              
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                                <th><input type="checkbox" id="checkall" onclick='selectAll()' title="Select all"/></td></th>
                                                <th>ID#</th>
                                                <th>Contact Name</th>
                                                <th>Phone</th>
                                                <th>Group</th>
                                       
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($contacts as $contact)
                                            <tr>
                                            
                                            <td><input type="checkbox" name="contact[]" id="checkall" value="{{ $contact->contact_id }}"/></td></td>
                                            </form>
                                            <td>{{ $contact->contact_id }}</td>
                                            <td>{{ ucfirst($contact->name) }}</td>   
                                            <td>{{ $contact->phone }}</td>
                                            <td>@if ($contact->contactGroup)
                                             {{ $contact->contactGroup->group_name }}
                                             @endif
                                             </td>
                                     



                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <a href="#" data-target="#edit-{{ $contact->contact_id }}" data-toggle="modal" id="show-modal"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="View"><i class="far fa-eye"></i> </button>  </a>
                                            <a href="#" data-target="#view-{{ $contact->contact_id }}" data-toggle="modal" id="show-modal"> <button class="btn btn-primary btn-sm" data-toggle="tooltip"  data-original-title="Edit"><i class="fa fa-edit"></i> </button></a>
                                            <button  @click.prevent="deleteItem('contactDeletepath',{{$contact->contact_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            
                                            </form>
                                            </div>
                                            </td>
                                            </tr>
                                            <!-- edit modal -->
                                            <div class="modal fade" id="edit-{{ $contact->contact_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">View Contact </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <contactview_component :contactsdata="{{json_encode($contact)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end edit modal -->
                                            <!-- view modal -->
                                            <div class="modal fade" id="view-{{ $contact->contact_id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Edit Contact </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                         
                                                         <contactsedit_component :contactsdata="{{json_encode($contact)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end view modal -->
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                    {!! $contacts->links() !!}
                                    <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Contact </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <contactcreate_component/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
             <!--  import -->              
                                            <div class="modal fade" id="importClient" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                    <h4>Import Contacts</h4>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="{{ route('batchimportcontacts')}}" method="post" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body bg-light">
                                                            <div class="alert alert-info shadow-sm">
                                                                <p class="mb-0">Download <a href="{{ url('/sample/clients.xlsx') }}">sample file</a></p>
                                                            </div>
                                                            <div class="col form-group">
                                                                <label for="import-file">Select file. Add Group ID to 'groups' column to add to group</label>
                                                                <input name="file" id="import-file" type="file" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-success btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-danger btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- / import -->


            
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    
    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
    
    
    
    
    
    
    <script type="text/javascript">

    // $(document).ready(function () {


    //     $('#master').on('click', function(e) {

    //      if($(this).is(':checked',true))  

    //      {

    //         $(".sub_chk").prop('checked', true);  

    //      } else {  

    //         $(".sub_chk").prop('checked',false);  

    //      }  

    //     });


    //     $('.delete_all').on('click', function(e) {


    //         var allVals = [];  

    //         $(".sub_chk:checked").each(function() {  

    //             allVals.push($(this).attr('data-id'));

    //         });  


    //         if(allVals.length <=0)  

    //         {  

    //             alert("Please select row.");  

    //         }  else {  


    //             var check = confirm("Are you sure you want to delete this row?");  

    //             if(check == true){  


    //                 var join_selected_values = allVals.join(","); 


    //                 $.ajax({

    //                     url: $(this).data('url'),

    //                     type: 'DELETE',

    //                     headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},

    //                     data: 'ids='+join_selected_values,

    //                     success: function (data) {

    //                         if (data['success']) {

    //                             $(".sub_chk:checked").each(function() {  

    //                                 $(this).parents("tr").remove();

    //                             });

    //                             alert(data['success']);

    //                         } else if (data['error']) {

    //                             alert(data['error']);

    //                         } else {

    //                             alert('Whoops Something went wrong!!');

    //                         }

    //                     },

    //                     error: function (data) {

    //                         alert(data.responseText);

    //                     }

    //                 });


    //               $.each(allVals, function( index, value ) {

    //                   $('table tr').filter("[data-row-id='" + value + "']").remove();

    //               });

    //             }  

    //         }  

    //     });


    //     $('[data-toggle=confirmation]').confirmation({

    //         rootSelector: '[data-toggle=confirmation]',

    //         onConfirm: function (event, element) {

    //             element.trigger('confirm');

    //         }

    //     });


    //     $(document).on('confirm', function (e) {

    //         var ele = e.target;

    //         e.preventDefault();


    //         $.ajax({

    //             url: ele.href,

    //             type: 'DELETE',

    //             headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},

    //             success: function (data) {

    //                 if (data['success']) {

    //                     $("#" + data['tr']).slideUp("slow");

    //                     alert(data['success']);

    //                 } else if (data['error']) {

    //                     alert(data['error']);

    //                 } else {

    //                     alert('Whoops Something went wrong!!');

    //                 }

    //             },

    //             error: function (data) {

    //                 alert(data.responseText);

    //             }

    //         });


    //         return false;

    //     });

    // });

</script>
    
    
    
@endsection

    