@php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
}
@endphp
@extends($layout)
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Settings</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Settings</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="{{ route($dashboard)}}" class="btn btn-white btn-border btn-round mr-2">Back</a>
                        </div>
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">My Settings</div>
                                        <ul class="list-group list-group-lg list-group-bordered">
                                            <li class="list-group-item" style="background:#f27200;color:#fff">Notification Settings</li>
                                            <li class="list-group-item border-right">
                                                <span class="col-md-4">Receive SMS</span>
                                                <span class="col-md-4">
                                                @if(Auth::user()->user_type == 'organization_user')
                                                    @if(Auth::user()->get_sms == 1)
                                                    <span class="badge badge-success">Yes</span>
                                                    @elseif(Auth::user()->get_sms == 0)
                                                    <span class="badge badge-danger">No</span>
                                                    @else
                                                    <span class="badge badge-warning">Not Set</span>
                                                    @endif
                                                @elseif(Auth::user()->user_type == 'organization')
                                                    @if(Auth::user()->get_sms == 1)
                                                    <span class="badge badge-success">Yes</span>
                                                    @elseif(Auth::user()->get_sms == 0)
                                                    <span class="badge badge-danger">No</span>
                                                    @else
                                                    <span class="badge badge-warning">Not Set</span>
                                                    @endif
                                                @endif
                                                </span>
                                                <span class="col-md-4">
                                                    <button class="btn btn-info btn-sm">Edit</button>
                                                </span>
                                            </li>
                                            <li class="list-group-item border-right">
                                                <span class="col-md-4">Receive Email</span>
                                                <span class="col-md-4">
                                                @if(Auth::user()->user_type == 'organization_user')
                                                    @if(Auth::user()->get_email == 1)
                                                    <span class="badge badge-success">Yes</span>
                                                    @elseif(Auth::user()->get_email == 0)
                                                    <span class="badge badge-danger">No</span>
                                                    @else
                                                    <span class="badge badge-warning">Not Set</span>
                                                    @endif
                                                @elseif(Auth::user()->user_type == 'organization')
                                                    @if(Auth::user()->get_email == 1)
                                                    <span class="badge badge-success">Yes</span>
                                                    @elseif(Auth::user()->get_email == 0)
                                                    <span class="badge badge-danger">No</span>
                                                    @else
                                                    <span class="badge badge-warning">Not Set</span>
                                                    @endif
                                                @endif
                                                </span>
                                                <span class="col-md-4">
                                                    <button class="btn btn-info btn-sm">Edit</button>
                                                </span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
            </div>
            </div>
        </div>
    </div>
    @endsection