<?php

namespace App\Models\fcmodels;

use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    protected $connection = 'mysql_newfc';
    protected $primaryKey = 'group_id';
    protected $table = 'groups';
  
    protected $fillable = [
        'group_id',
        'group_name',
        'description',
        'status',
        'organization_id'
    ];    
    //
    //group<>Org relationship
    public function groupOrg()
    {
        return $this->belongsTo(Organization::class,'organization_id');
    }
    
    public function groupContacts()
    {
        return $this->hasMany(Contact::class,'group_id');
    }
   
}
