<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerClientPayment extends Model
{
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    //
    protected $primaryKey='client_pay_id';
    protected $fillable = [
        'client_pay_id',
        'client_pay_amount',
        'client_pay_status',
        'client_pay_ref',
        'customer_client_cust_client_id',
        'customer_client_batch_id',
        'client_pay_batch_id',
        'client_pay_tracking',
        'client_b2b_number',
        'client_pay_account_name',
        'client_pay_remarks',
        'client_type',
        'customer_cust_id'
    ];
    //clientpayment<> client relationship
    public function ClientPaymentClient()
    {
        return $this->belongsTo(CustomerClient::class, 'customer_client_cust_client_id','cust_client_id');
    }
    //client payment <> client batch rshp
    public function ClientPaymentBatch()
    {
        return $this->belongsTo(ClientBatch::class, 'customer_client_batch_id','id');
    }
    //client payment <> customer rlshp
    public function ClientPaymentCustomer()
    {
        return $this->belongsTo(Customer::class, 'customer_cust_id','cust_id');
    }
    //client pay <> trans erros
    public function payError()
    {
        return $this->hasMany(TransactionError::class, 'client_pay_id');
    }
}
