<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustomerClient extends Model
{
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    //
    protected $primaryKey='cust_client_id';
    protected $fillable = [
        'cust_client_id',
        'cust_client_fullname',
        'cust_client_idno',
        'cust_client_phone',
        'cust_client_status',
        'customer_cust_id',
        'created_by'
    ];
    //client<>customer relationship
    public function ClientCustomer()
    {
        return $this->belongsTo(Customer::class, 'customer_cust_id','cust_id');
    }
    //client<>clientgroup relationship
    public function ClientClientGroup()
    {
        return $this->hasOne(CustomerClientGroup::class,'customer_client_cust_client_id');
    }
    //client<>clientpayment relationship
    public function ClientClientPayment()
    {
        return $this->hasMany(CustomerClientPayment::class,'cust_client_cust_client_id');
    }
    //client<>clientscheduledpayment relationship
    public function ClientScheduledPayment()
    {
        return $this->hasMany(CustomerScheduledClientPayment::class,'cust_client_cust_client_id');
    }
}
