export default {
    data() {
      return {
        fields: {},
        errors: {},
        success: false,
        loaded: true,
        action: '', //save action
        action2: '', //edit action
        action3: '', //delete
        text: '',
        redirect: '',
        client: 0,
        clients: [],
        myClient: 0,
        myClients: [],
        myGroup: 0,
        myGroups: [],
        group: 0,
        groups: [],
        batch: 0,
        batches: [],

      }
    },
  
    methods: {
      
      submit() {
        if (this.loaded) {
          this.loaded = false;
          this.success = false;
          this.errors = {};
          
          swal({
              title: "Is the correct Mpesa number: "+this.fields.number+"?",
              text: "Once Approved, you will not be able to reverse the transaction!",
              icon: "info",
              buttons: true,
              dangerMode: true,
            })
            .then((willSend) => {
              if (willSend) {
                    axios.post(this.action, this.fields).then(response => {
                    this.fields = {}; //Clear input fields.
                    this.loaded = true;
                    this.success = true;
                    //sweet alert with redirect
                    var mtext = this.text;
                    var back = this.redirect;
                    swal({
                      title: 'Success',
                      text: mtext,
                      icon: 'success',
                      type: 'success',
                      buttons:{
                        confirm: {
                          text : 'Go Back',
                          className : 'btn btn-success'
                        },
                        cancel: {
                          text: 'Add more..',
                          visible: true,
                          className: 'btn btn-info'
                        }
                      }
                    }).then((Delete) => {
                      if (Delete) {
                        window.location.href = back;
                      } else {
                        swal.close();
                      }
                    });
        
                  }).catch(error => {
                    this.loaded = true;
                    if (error.response.status === 422) {
                      this.errors = error.response.data.errors || {};
                    }
                  });
                
              } else {
                //show the form
              }
              
            });
         
        }
      },
      update() {
        
        if (this.loaded) {
          this.loaded = false;
          this.success = false;
          this.errors = {};
          console.log(this.fields);
          axios.post(this.action2, this.fields).then(response => {
            this.fields = {}; //Clear input fields.
            this.loaded = true;
            this.success = true;
            //console.log(response.data);
            //sweet alert with redirect
            var mtext = this.text;
            var back = this.redirect;
            swal({
              title: 'Success',
              text: mtext,
              icon: 'success',
              type: 'success',
              buttons:{
                confirm: {
                  text : 'Go Back',
                  className : 'btn btn-success'
                },
                cancel: {
                  text: 'Edit Again',
                  visible: true,
                  className: 'btn btn-info'
                }
              }
            }).then((Delete) => {
              if (Delete) {
                window.location.href = back;
              } else {
                swal.close();
              }
            });


          }).catch(error => {
           
            this.loaded = true;
            if (error.response.status === 422) {
              this.errors = error.response.data.errors || {};
             
            }
            console.log(this.errors);
          });
        }
      },
     ///get clients and group data
     getClients: function(){
      axios.get('/getClients')
      .then(function (response) {
         this.clients = response.data;
         console.log(this.clients);
      }.bind(this));

    },
    getGroups: function() {
        axios.get('/getGroups')
        .then(function(response){
            this.groups = response.data;
        }.bind(this));
    },
    getMyClients: function() {
      axios.get('/getMyClients')
      .then(function(response){
          this.myClients = response.data;
          this.options = response.data;
      }.bind(this));
    },
    getMyGroups: function() {
      axios.get('/getMyGroups')
      .then(function(response){
          this.myGroups = response.data;
      }.bind(this));
    },
    getBatch: function() {
      axios.get('/user/getBatch')
      .then(function(response){
          this.batches = response.data;
      }.bind(this));
    },
    },
    created: function(){
      this.getClients(),this.getGroups(),this.getMyClients(),this.getMyGroups(),this.getBatch()
  }
  }