@php
if(Auth::user()->user_type == 'organization_user')
{
    $layout = 'bmviews.layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}

elseif(Auth::user()->user_type == 'organization')
{
 $layout = 'bmviews.layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

}
else
{
 $layout = 'bmviews.layouts.admin';
 $dashboard='admin-dashboard';
 $fdashboard='admin-dashboard';
}
@endphp
@extends($layout)
@section('content')
<div id="vue-admin-user">
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Groups</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route($dashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Groups</a>
                                    </li>
                                </ul>
                        </div></div>
                        
                        <div class="ml-md-auto py-2 py-md-0">
                           @if(Auth::user()->user_type == 'organization')
                            <a href="{{route($dashboard)}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <!--<button type="button" class="btn btn-white btn-round" data-toggle="modal" data-target="#myModal">-->
                            <!--   <i class="fa fa-plus"></i> Add Group-->
                            <!--</button>-->
                                                    
                            @else
                             <a href="{{route($fdashboard)}}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                              <button type="button" class="btn btn-white btn-round" data-toggle="modal" data-target="#myModal">
                               <i class="fa fa-plus"></i> Add Group
                              </button>
                               <!--<a href="{{ route('groups.create')}}" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Group</a> -->
                            @endif
                        </div>
                        
                    </div>
                </div>
                <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Groups Detail</div>
                                        @if ($errors->any())
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                            <strong>Error! </strong>There were some errors with inputs.
                                            <ul>
                                                @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                            </ul>
                                            </div>

                                        @endif
                                        @include('layouts.messages')
                                        @if(!$customerGroups->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="admin-users-table" class="display table table-striped table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Group Name</th>
                                                    <th>Created By</th>
                                                    <th>Group status</th>
                                                    <th class="text-center" style="width: 10%">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                    <th>Group Name</th>
                                                    <th>Created By</th>
                                                    <th>Group status</th>
                                                    <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($customerGroups as $customerGroup)
                                            <tr>
                                            <td>{{ ucfirst($customerGroup->cust_group_name) }}</td>
                                            <td>{{ ucfirst($customerGroup->created_by) }}</td>
                                            <td>@if($customerGroup->cust_group_status == 1)
                                                <span class="badge badge-success">Active</span>
                                                @elseif($customerGroup->cust_group_status == 0)
                                                <span class="badge badge-danger">Inactive</span>
                                                @endif
                                            </td>
                                           
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <a href="{{ url('/bmp/groups/show',$customerGroup->cust_group_id)}}"> <button class="btn btn-success btn-sm" data-toggle="tooltip"  data-original-title="View"><i class="far fa-eye"></i> </button>  </a>
                                            @if(Auth::user()->user_type != 'organization')
                                            <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#myModalEdit-{{$customerGroup->cust_group_id}}" id="show-modal"><i class="fa fa-edit"></i> </button>
                                            <button  @click="deleteItem('deletegrouppath',{{$customerGroup->cust_group_id}})" data-toggle="tooltip"  data-original-title="Delete" name="delete" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash-alt"></i> 
                                            </button>
                                            @endif
                                            </div>
                                            <!-- modal -->
                                            <div id="myModalEdit-{{$customerGroup->cust_group_id}}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Edit Customer Group [{{ucfirst($customerGroup->cust_group_name)}}]<strong></strong></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        
                                                    <edit_group :groupdata="{{json_encode($customerGroup)}}"></edit_group>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /end modal -->
                                            </td>
                                            </tr>
                                            @endforeach


                                            </tbody>
                                        </table>
                                                                                   
                                      
                                    </div>
                                </div>
                            </div>
                            @endif     
                            </div>
            </div>
            </div>
            </div>
        </div>
    </div>
      <!-- add user modal -->
     
      <div id="myModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Add Group<strong></strong></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                        <add_group :cust_id="{{json_encode($id)}}"></add_group>
                                                                                                                
                                                    </div>
                                                </div>
                                            </div>
                                            </div>
                                            <!-- /end modal -->
    </div>
   
    @endsection