<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientBatch extends Model
{
    use SoftDeletes;
    protected $connection = 'mysql_bmp';
    
    protected $primaryKey='id';
    protected $fillable = [
        'client_phone',
        'client_idno',
        'client_name',
        'transfer_amount',
        'client_batch_id',
        'client_batch_status',
        'client_batch_customer_id',
        'client_batch_customer_user_id'
    ];
    //batch <> customer rlshp
    public function ClientBatchCustomer()
    {
        return $this->belongsTo(Customer::class, 'client_batch_customer_id','cust_id');
    }
    //batch <> customer_user rlshp
    public function ClientBatchCustomerUser()
    {
        return $this->belongsTo(CustomerUser::class, 'client_batch_customer_user_id','cust_user_id');
    }
    //client batch <> client payment rlshp
    public function BatchClientPayment()
    {
        return $this->hasMany(CustomerClientPayment::class,'customer_client_batch_id');
    }
}
