<?php

namespace App\Http\Controllers\WarrantControllers;

use App\Http\Controllers\Controller;
Use Maatwebsite\Excel\Facades\Excel;
use App\Models\atmodels\Airtime_contact;
use App\Models\atmodels\Airtime_group;
use App\Models\atmodels\Currency_credit;
use App\Models\bmmodels\CustomerClient;
use App\Models\fcmodels\Contact;
use App\Models\fcmodels\ImeData;

use App\Models\atmodels\Airtime_Contacts_Group_Association;

use Illuminate\Http\Request;
use App\Imports\IMEImports\IMEWarrantImport;

use Auth;
use Exception;
use Hash;
use Log;
use DB;
class WarrantIMEController extends Controller
{
    //return contacts view
    public function index()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $shop_id=Auth::user()->shop_id;            
            $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount'); 
            $imedatarecords = ImeData::orderBy('ime_data_id', 'DESC')->get();
           
            return view('warrantviews.contacts.index', compact('imedatarecords','wallet'));
        }
    }
     //return contacts view
     public function index1()
     {
        $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $shop_id=Auth::user()->shop_id;            
            $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount'); 
            $contacts = Airtime_contact::where('customer_id',$customer_id)->with('contactGroup')->get();           
            $groups = Airtime_group::where('customer_id',$customer_id)->get();
           
            return view('bundleviews.contacts.index1', compact('contacts','groups','wallet'));
         } 
     
    //
    public function store(Request $request)
    {
        Log::info($request);
        $request->validate([
            'imei_data_number' => 'required',
        ]);
        $shop_id=Auth::user()->shop_id;   

        //check duplicate
        $check=ImeData::where('imei_data_number',$request->imei_data_number)->get();
        if($check->count())
        {
            $phones_arr=$check[0]->imei_data_number;
        
            return response()->json(["errors"=>["imei_data_number"=>["imei_data_number number(s) already added ".json_encode($phones_arr)]]],422);
        }
   
        $data = new ImeData();
        $data->imei_data_number = $request->imei_data_number;
       // $data->product = $request->product;
        //$data->description = $request->description;
        $data->valid_till = $request->valid_till;
        $data->organization_id = $shop_id;
        $data->save();


    }

    //import contacts
    public function import(Request $request) 
    {

        if(Auth::user()->user_type == 'organization_user')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort('401');
        }


         request()->validate([
            'file' => 'required|max:2000'
         ],
         [
             'file.required' => 'Please select a file first',
             'file.max' => 'Please select a file with size under 2MBs',
         ]);
        $path = $request->file;
        $extensions = array("xls","xlsx","xlm","xla","xlc","xlt","xlw","csv");

        $result = array($request->file('file')->getClientOriginalExtension());
        
        if(in_array($result[0],$extensions)){
            Excel::import(new IMEWarrantImport($customer_id,$request->group), $path);
       
            return back(); 
        }
        else{
           return redirect()->back()->with('failure', 'Please select excel file!');
        }
    }
    //edit grp
    public function update(Request $request)
    {
        $request->validate([
            'imei_data_number' => 'required',
        ]);
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
  
        
        $data = ImeData::findOrFail($request->ime_data_id);
        $data->imei_data_number = $request->imei_data_number;
       // $data->product = $request->product;
        //$data->description = $request->description;
        $data->valid_till = $request->valid_till;
        $data->organization_id = $shop_id;
        $data->save();
    }

    //delete group
    public function destroy($id)
    {
        Log::info($id);
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = ImeData::findOrFail($id);
        $data->delete();
        return redirect()->back()->with('success', 'Deleted succesfully');
    }
    //delete all contacts
    public function destroyAllContacts()
    {
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_contact::where('customer_id',$customer_id)->delete();
        return redirect()->back()->with('success', 'Deleted succesfully');
        
    }
    //delete selected
    public function destroySelectedContacts(Request $request)
    {
        $id = $request->contact;
      
        if(empty($id))
        {
            return redirect()->back()->with('failure', 'Select atleast one contact');
        }
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_contact::where('customer_id',$customer_id)->whereIn('contact_id',$id)->delete();
        return redirect()->back()->with('success', 'Deleted succesfully');
    }

    //deleteselectedcontact
    public function delselectedContacts($id){
        $contactsids=explode(',',$id);
        
        if(empty($contactsids))
        {
            return redirect()->back()->with('failure', 'Select atleast one contact');
        }
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
        }
        else{
            return abort(401);
        }
        $data = Airtime_contact::where('customer_id',$customer_id)->whereIn('contact_id',$contactsids)->delete();
        $status="";
        if($data){
            return $status="success";
        }
        else{
            $status="failed";   
        }
        return $status;

    }
}
