<?php

namespace App\Http\Controllers\FCControllers\Survey;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\fcmodels\Survey;
use App\Models\fcmodels\ImeData;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Organization;
use App\Models\fcmodels\Organizationshortcode;
use App\Models\fcmodels\SurveyRequest;
use App\Classes\FCClasses\SendSms;
use App\Models\atmodels\Airtime_sending_credential;
use App\Models\fcmodels\Ime_Trial;
use EloquentBuilder;
use Auth;
use Log;

class SumsungSurveyController extends Controller
{

    public function index(Request $request)
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $imeistatus = Ime_Trial::where('to_shortcode','20384')->get()->pluck('status');
     //   $requests = Ime_Trial::where('to_shortcode','20384')->get();
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');

        $query =Ime_Trial::where('to_shortcode','20384');
        $requests=EloquentBuilder::to($query,request()->all())->orderBy('ime_trials_id','desc')->get();
        return view('warrantviews.history.index',compact('requests','wallet','imeistatus'));
    }
    
    public function validimes(Request $request)
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $imeistatus = Ime_Trial::where('to_shortcode','20384')->get()->pluck('status');
        $requests = Ime_Trial::where('status','1')->get();
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        return view('warrantviews.history.valid',compact('requests','wallet','imeistatus'));
    }
    public function invalidimes(Request $request)
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $imeistatus = Ime_Trial::where('to_shortcode','20384')->get()->pluck('status');
        $requests = Ime_Trial::where('status','0')->get();
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        return view('warrantviews.history.invalid',compact('requests','wallet','imeistatus'));
    }


    public function checkime(Request $request)
    {
        
        Log::info($request);
        
            $from = $request->from;  //$_POST["from"]; #sender of message
            ///$from =  trim(substr($from,1));
        $to = $request->to;      $_POST["to"]; #shortcode receiving the message
        $text = $request->text;        //trim($_POST["text"]); # message from user
        $date = $request->date;           //$_POST["date"]; #date it was received by PRSP/MNO
      
        $url = "";
          //get imei from message
            $split = explode(" ",$text);
            $imei = $split[1];
            //check if exist
            $imeis = ImeData::where('imei_data_number',$imei)->first();
            Log::info($imeis);
        
              $credentials = Airtime_sending_credential::where('customer_id',1888)->first();
        $username = $credentials['username'];
        $password = $credentials['password'];
        
        
        if($imeis)
        
        {
            $serial_no=$imeis->imei_data_number;
        $valid_till=$imeis->valid_till;
                  $message = 'Your TV of serial number '.$serial_no.' has 24 Month warranty valid until '.$valid_till.'';
          $phone=$from;
          $smsobject=new SendSms($username,$password);
  
          $textstatus=$smsobject->sendMessage($phone,$message);
          $text_status='1';
        }
    else{
                  $message = 'Your TV of serial number '.$imei.' has no valid warranty. Contact Samsung Service center';
          $phone=$from;
          $smsobject=new SendSms($username,$password);
    
          $textstatus=$smsobject->sendMessage($phone,$message);
          $text_status='0';
        }

        
        $sumsung = new Ime_Trial();
        $sumsung->linkId = $request->linkId;
        $sumsung->text_message = $request->text;
        $sumsung->to_shortcode = $request->to;
        $sumsung->mess_id = $request->id;
        $sumsung->cost = $request->cost;
        $sumsung->trial_date = $request->date;
        $sumsung->trial_from = $request->from;
        $sumsung->networkCode = $request->networkCode; 
        $sumsung->status = $text_status;  
        $sumsung->save();
        // //log
       
        // $surveylog = new AuditLog();
        // $surveylog->audit_module = $type;
        // $surveylog->audit_activity = "Survey of name: ".$request->name." created by ".$type." ID# " .$id;
        
        // $surveylog->user_category = $type;
        // $surveylog->user_id = $id; 
        // $surveylog->save();
        
        // return 'Saved';
    }


    public function store(Request $request)
    {
   
        $survey = new ImeData();
        $survey->name = $request->name;
        $survey->shortcode =  $request->shortcode_id['shortcode'];   
        $survey->organization_id = $id;
        $survey->participant_preloaded = $request->participant_preloaded;
        $survey->save();
        //log
       
        $surveylog = new AuditLog();
        $surveylog->audit_module = $type;
        $surveylog->audit_activity = "Survey of name: ".$request->name." created by ".$type." ID# " .$id;
        
        $surveylog->user_category = $type;
        $surveylog->user_id = $id; 
        $surveylog->save();
        
        return 'Saved';
    }

    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        
        $type='';
        $id='';
        
          if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            $type='organization';
        }
        else{
            return abort('401');
        }
        
        $surveydets = Survey::findOrFail($request->id);
        $survey = Survey::findOrFail($request->id);
        $survey->name = $request->name;
        $survey->shortcode = $request->shortcode;
        $survey->status = $request->status;
        $survey->save();
        //log
        $surveylog = new AuditLog();
        $surveylog->audit_module = $type;
        $surveylog->audit_activity = "Survey of details: ".$surveydets." updated to ".$survey." by ".$type." ID# " .$id;
        
        $surveylog->user_category = $type;
        $surveylog->user_id = $id; 
        $surveylog->save();
        
        return 'Saved';
    }

    
    public function destroy($iid)
    {
        $type='';
        $id='';
        
          if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            $type='organization';
        }
        else{
            return abort('401');
        }
        $surveydets = Survey::findOrFail($iid);
        $survey = Survey::findOrFail($iid);
        $survey->delete();
        //log
        $surveylog = new AuditLog();
        $surveylog->audit_module = $type;
        $surveylog->audit_activity = "Survey of details: ".$surveydets." deleted by ".$type." ID# " .$id;
        
        $surveylog->user_category = $type;
        $surveylog->user_id = $id; 
        $surveylog->save();
        
        return 'Deleted';
    }
    public function getHelp($id){
        return "hello ".$id;
    }
       //get getShortcode
    public function getShortcode()
    {
        $type='';
        $id='';
        
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
            $type='organization';
        }
        else{
            return abort('401');
        }
            $Shortcodes = Organizationshortcode::where('organization_id',$id)->get();
            return $Shortcodes;
    }
}
