<?php

namespace App\Http\Controllers\FCControllers;
Use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use App\Models\fcmodels\Import;
use Auth;
use App\Models\fcmodels\CountryRate;
use App\Models\fcmodels\Country;

use App\Imports\FCImports\SmscontactssImport;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;

class ImportCsvController extends Controller
{ 
    public function index()
    {

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
                $mycountries = CountryRate::where('shopId',$api_account)->with('rateCountry')->get();
        //return $mycountries;
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
            $contacts = Import::where('status','0')->where('organization_id',$id)->where('message','!=',NULL)->with('ImportOrg')->get();
            //return $contacts;
            return view('fcviews.exceluploads.index',compact('contacts','wallet','mycountries'));
 
}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    //import clients to db
    public function import(Request $request) 
    {

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
        }
       else{
            return abort('401');
        }


         request()->validate([
            'file' => 'required|max:2000'
         ],
         [
             'file.required' => 'Please select a file first',
             'file.max' => 'Please select a file with size under 2MBs',
             'file.mimes' => 'Accepted file types are Excel with extensions [*.xlsx,*.xls,*.csv]',
         ]
    );
        $path = $request->file;
        $extensions = array("xls","xlsx","xlm","xla","xlc","xlt","xlw","csv");

        $result = array($request->file('file')->getClientOriginalExtension());
        
        if(in_array($result[0],$extensions)){
            Excel::import(new SmscontactssImport($id), $path);
       
            return redirect()->back(); 
            
        }else{
           return redirect()->back()->with('failure', 'Please select excel file!');
        }


        
       // return $request->file;
    }

    

    //store
    public function storeContact(Request $request)
    {
        if(Auth::check())
        {
            $oid = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        $request->validate([
       
            'import_name' => 'required',
                ]);
        $data = new Import();
        $data->import_name = $request->import_name;
        $data->phone = $request->phone;
        $data->group_id = $request->group_id;

        $data->organization_id = $oid;


        // return $data;
        $data->save ();
        //log
        $importLog = new AuditLog();
        if(Auth::user()->user_type == 'organization')
        {
            $importLog->audit_module = "Organization";
            $importLog->audit_activity = "Import of details ".$data." added by Organization  ID ".$oid;
           
            $importLog->user_category = "Organization";
            $importLog->user_id = $oid;
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $importLog->audit_module = "Organization User";
            $importLog->audit_activity = "Import of details ".$data." added by Organization User  ID ".$oid;
           
            $importLog->user_category = "Organization User";
            $importLog->user_id = $oid;
        }
        $importLog->save();
        

        $sms = Bulksms();   
        return view('smscomposer.index',compact('sms'));


        return response()->json($data);
    }





 //edit
 public function editContacts(Request $request)

 {
     if(Auth::check())
        {
            $oid = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
     
        
  //  try
    { 
        request()->validate([
            'name'=> 'required',
  
        ]);
        return $request;
    //current customer 
    $id=$request->id;
    $contactsdets = Contact::where('contact_id',$id)->get();
    //update
    $data = Contact::findOrFail($id);
   
    $data->name = $request->get('name');
    $data->phone = $request->get('phone');
    $data->group_id = $request->get('group_id');



    // log data
    $importLog = new AuditLog();
        if(Auth::user()->user_type == 'organization')
        {
            $importLog->audit_module = "Organization";
            $importLog->audit_activity = "Import of details ".$data." edited by Organization  ID ".$oid;
           
            $importLog->user_category = "Organization";
            $importLog->user_id = $oid;
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $importLog->audit_module = "Organization User";
            $importLog->audit_activity = "Import of details ".$data." edited by Organization User  ID ".$oid;
           
            $importLog->user_category = "Organization User";
            $importLog->user_id = $oid;
        }
        $importLog->save();
    $data->save();

      return redirect()->back()
        ->with('success','Contacts Edited Succesfully.'); 
        
    }
  //  catch (Exception $exception)
   // {
      //  return back()->withInput()
        //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
  //  }
 }








 //delete
 public function deleteContact(Request $request,$id){
        if(Auth::check())
        {
            $oid = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
   
    //find user details to delete
    $Contact = Contact::where('contact_id',$id)->get();
    //set delete
    $deleteContact = Contact::find($id);
    $deleteContact->delete();
    //set logging
    $importLog = new AuditLog();
        if(Auth::user()->user_type == 'organization')
        {
            $importLog->audit_module = "Organization";
            $importLog->audit_activity = "Import of details ".$deleteContact." deleted by Organization  ID ".$oid;
           
            $importLog->user_category = "Organization";
            $importLog->user_id = $oid;
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $importLog->audit_module = "Organization User";
            $importLog->audit_activity = "Import of details ".$deleteContact." deleted by Organization User  ID ".$oid;
           
            $importLog->user_category = "Organization User";
            $importLog->user_id = $oid;
        }
        $importLog->save();
}



//edit
 public function editImports(Request $request)

 {
     if(Auth::check())
        {
            $oid = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        

  //  try
    { 
        request()->validate([
            'import_name'=> 'required',
  
        ]);
       // return $request;
    //current customer 
    $id=$request->import_id;
    
    $contactsdets = Import::where('import_id',$id)->get();
    //update
   
    $data = Import::findOrFail($id);
    
    $data->import_name = $request->get('import_name');
    $data->phone = $request->get('phone');
    $data->message = $request->get('message');

 

    // log data
    $importLog = new AuditLog();
        if(Auth::user()->user_type == 'organization')
        {
            $importLog->audit_module = "Organization";
            $importLog->audit_activity = "Import of details ".$contactsdets." changed to ".$data." edited by Organization  ID ".$oid;
           
            $importLog->user_category = "Organization";
            $importLog->user_id = $oid;
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $importLog->audit_module = "Organization User";
            $importLog->audit_activity = "Import of details ".$contactsdets." changed to ".$data." edited by Organization  ID ".$oid;
           
            $importLog->user_category = "Organization User";
            $importLog->user_id = $oid;
        }
        $importLog->save();
    $data->save();

      return redirect()->back()
        ->with('success','Contacts Edited Succesfully.'); 
        
    }
  //  catch (Exception $exception)
   // {
      //  return back()->withInput()
        //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
  //  }
 }



 //delete
 public function DeleteExcelUpload(Request $request,$id){
     if(Auth::check())
        {
            $oid = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        
    //find user details to delete
    $Contact = Import::where('import_id',$id)->get();
    //set delete
    $deleteContact = Import::find($id);
    $deleteContact->delete();
    //set logging
    $importLog = new AuditLog();
        if(Auth::user()->user_type == 'organization')
        {
            $importLog->audit_module = "Organization";
            $importLog->audit_activity = "Import of details ".$Contact." deleted by Organization  ID ".$oid;
           
            $importLog->user_category = "Organization";
            $importLog->user_id = $oid;
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $importLog->audit_module = "Organization User";
            $importLog->audit_activity = "Import of details ".$Contact." deleted by Organization User  ID ".$oid;
           
            $importLog->user_category = "Organization User";
            $importLog->user_id = $oid;
        }
        $importLog->save();
}






}
