<?php

namespace App\Http\Controllers\FCControllers;
Use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Http\Request;
use App\Models\fcmodels\Contact;
use Auth;
use App\Imports\FCImports\ClientsImport;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;
use Log;
class ExcelUploadsController extends Controller
{
  
    public function index()
    {

        if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
            $api_account = Auth::guard('organization')->user()->api_account;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
            $api_account = Auth::guard('web')->user()->api_account;
        }
        else{
            return abort('401');
        }
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
            $contacts = Contact::with('contactGroup')->get();
            //return $contacts;
            return view('exceluploads.index',compact('contacts','wallet'));
 
    }
    //import clients to db
    public function import(Request $request) 
    {

        if(Auth::guard('organization')->check())
        {
            $id = Auth::guard('organization')->user()->organization_id;
        }
        else if(Auth::guard('web')->check())
        {
            $id = Auth::guard('web')->user()->organization_id;
        }
        else{
            return abort('401');
        }


         request()->validate([
            'file' => 'required|max:2000'
         ],
         [
             'file.required' => 'Please select a file first',
             'file.max' => 'Please select a file with size under 2MBs',
             'file.mimes' => 'Accepted file types are Excel with extensions [*.xlsx,*.xls,*.csv]',
         ]
    );
        $path = $request->file;
       $extensions = array("xls","xlsx","xlm","xla","xlc","xlt","xlw","csv");

        $result = array($request->file('file')->getClientOriginalExtension());
        
        if(in_array($result[0],$extensions)){
            Excel::import(new ClientsImport($id), $path);
       
            return redirect()->back(); 
            
        }else{
           return redirect()->back()->with('failure', 'Please select an excel file!');
        }
        
      
        
        return $request->file;
    }

    

    //store
    public function storeContact(Request $request)
    {
        $request->validate([
       
            'name' => 'required',
    
                    
                ]);
        $data = new Contact();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->group_id = $request->group_id;

        $data->organization_id = Auth::guard('organization')->user()->organization_id;


        // return $data;
        $data->save ();
        //log
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Organization";
        $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::guard('organization')->user()->organization_id;
       
        $adminLog->user_category = "Admin";
        $adminLog->user_id = Auth::guard('organization')->user()->organization_id;
        ;
        $adminLog->save();
        
        return response()->json($data);
    }





 //edit
 public function editContacts(Request $request)

 {

  //  try
    { 
        request()->validate([
            'name'=> 'required',
  
        ]);
        return $request;
    //current customer 
    $id=$request->id;
    $contactsdets = Contact::where('contact_id',$id)->get();
    //update
    $data = Contact::findOrFail($id);
   
    $data->name = $request->get('name');
    $data->phone = $request->get('phone');
    $data->group_id = $request->get('group_id');



    // log data
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::guard('organization')->user()->organization_id;
   
    $adminLog->user_category = "Admin";
    $adminLog->user_id = Auth::guard('organization')->user()->organization_id;
    ;
    $adminLog->save();
    $data->save();

      return redirect()->back()
        ->with('success','Contacts Edited Succesfully.'); 
        
    }
  //  catch (Exception $exception)
   // {
      //  return back()->withInput()
        //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
  //  }
 }








 //delete
 public function deleteContact(Request $request,$id){
    //find user details to delete
    $Contact = Contact::where('contact_id',$id)->get();
    //set delete
    $deleteContact = Contact::find($id);
    $deleteContact->delete();
    //set logging
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization of details: ".$deleteContact." deleted by Admin ID#" .Auth::guard('organization')->user()->organization_id;
    
    $adminLog->user_category = "organization";
    $adminLog->user_id = Auth::guard('organization')->user()->organization_id; 
    $adminLog->save();
}
}



