<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use App\Models\fcmodels\Department;
use Auth;
use App\Models\fcmodels\AuditLog;
use App\Models\fcmodels\Wallet;
use Log;

class DepartmentController extends Controller
{

    // public function __construct()
    // {
    //     //defining our middleware for this controller
    //     $this->middleware('auth:organization');
    // }
  
    public function index()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
    
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $departments = Department::where('organization_id',$id)->get();
        return view('fcviews.departments.index',compact('departments','wallet'));
 
    }

    //get departments
    public function getDepartments()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
            $departments = Department::where('organization_id',$id)->get();
            return $departments;
    }





    //store
    public function storeDepartment(Request $request)
    {
        $request->validate([
       
            'department_name' => 'required|string',
    
                    
                ]);
        $data = new Department();
        $data->name = $request->department_name;
        $data->organization_id = Auth::user()->organization_id;


        // return $data;
        $data->save ();
        //log
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Organization";
        $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
       
        $adminLog->user_category = "Admin";
        $adminLog->user_id = Auth::user()->organization_id;
        ;
        $adminLog->save();
        
        return response()->json($data);
    }



   //edit
   public function editDepartment(Request $request)

   {

    //  try
      { 
          request()->validate([
              'name'=> 'required',
    
          ]);
         // return $request;
      //current customer 
      $id=$request->id;
      $departmentdets = Department::where('department_id',$id)->get();
      //update
      $department = Department::findOrFail($id);
     
      $department->name = $request->get('name');
     
      // log data
      $adminLog = new AuditLog();
      $adminLog->audit_module = "Organization";
      $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
     
      $adminLog->user_category = "Admin";
      $adminLog->user_id = Auth::user()->organization_id;
      ;
      $adminLog->save();
      $department->save();

        return redirect()->back()
          ->with('success','Department Edited Succesfully.'); 
          
      }
    //  catch (Exception $exception)
     // {
        //  return back()->withInput()
          //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
    //  }
   }

    
 //delete
 public function deleteDepartment($id){
   
    //find user details to delete
    $admin = Department::findOrfail($id);
    //where('department_id',$id)->get();
    //set delete
    $deleteDepartment = Department::find($id);
    $deleteDepartment->delete();
    //set logging
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization of details: ".$admin." deleted by Admin ID#" .Auth::user()->organization_id;
    
    $adminLog->user_category = "organization";
    $adminLog->user_id = Auth::user()->organization_id; 
    $adminLog->save();
    
    return $deleteDepartment;
    
}


}



