<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;


use Auth;
use Hash;
use App\Models\bmmodels\AdminUser;

use App\Models\bmmodels\CustomerUser;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\AuditLog;
use Exception;


class ProfileController extends Controller
{
    
    /**
    * Display a listing of the resource.
    *
    * @return \Illuminate\Http\Response
    */
   public function index($id)
   {
        if(Auth::user()->user_type == 'organization')
        {
            $uid = Auth::user()->bulk_cust_id;
            $AuditLogs = AuditLog::where('user_category','Customer' )->where('user_id',$uid)->get();
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $uid = Auth::user()->cust_user_id;
            $AuditLogs = AuditLog::where('user_category','User' )->where('user_id',$uid)->get();
        }
        else
        {
            $uid = Auth::user()->admin_id;
            $AuditLogs = AuditLog::where('user_category','Admin')->where('user_id',$uid)->get();
        }
       
       return view('bmviews.history.index', compact('AuditLogs'));
   }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function show()
    {
        return view('bmviews.home');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function customerprofile($id)
    {
        //
        $customer = Customer::findOrFail($id);
        return view('bmviews.profile.CustomerProfile',compact('customer'));
    }
  

    public function adminprofile($id)
    {
        //
    

        $admin = AdminUser::findOrFail($id);
        return view('bmviews.admin-user.details',compact('admin'));


    }
  
    public function UserProfile($id)
    {
        //
       // $customerUsers = customerUser::all();
       // return view('users.details', compact('customerUsers'));
        //return view('users.details');

        $customerUser = CustomerUser::findOrFail($id);
        return view('bmviews.profile.UserProfile',compact('customerUser'));


    }

}

