<?php

namespace App\Http\Controllers\BMControllers;
use EloquentBuilder;
use Illuminate\Http\Request;
use App\Models\bmmodels\CustomerWalletTransaction;
use App\Models\bmmodels\CustomerClientPayment;
use App\Models\bmmodels\CustomerClient;
use App\Models\bmmodels\CustomerGroup;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\BusinessNumber;
use App\Models\bmmodels\CustomerClientGroup;
use App\Models\bmmodels\AuditLog;
use App\Models\bmmodels\ClientBatch;
use App\Models\bmmodels\Rate;
use App\Models\fcmodels\Contact;
use App\Models\atmodels\Airtime_contact;
use Fouladgar\EloquentBuilder\Exceptions\NotFoundFilterException as NotFoundFilter;
use Illuminate\Support\Arr;
use Auth;
use Log;
use App\Libs\Mobisky;

class PaymentController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('auth:admin');
    // }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $id = '';
        if(Auth::user()->user_type == 'organization_user')
        {
        try
            {
            //get  customer id
            $id = Auth::user()->customer_cust_id;
            //get customer clients
            $batches = ClientBatch::where('client_batch_customer_id',$id)->groupBy('client_batch_id')->get();
            $mygroups = CustomerGroup::where('customer_cust_id',$id)->get();
            $mypaybills=BusinessNumber::where('business_customer_id',$id)->get();
            $clients = CustomerClient::where('customer_cust_id',$id)->pluck('cust_client_id');
            $client_batchs = ClientBatch::where('client_batch_customer_id',$id)->pluck('id');
            //get customer payments
            // $query = CustomerClientPayment::whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                                            // ->where('customer_cust_id',$id);
            /* if($request->has('phone')){
                $cli_phone = substr($request->phone,-9);
                $cli_id = CustomerClient::where('cust_client_phone',$cli_phone)->pluck('cust_client_id');
                $payments = $query->where('customer_client_cust_client_id','<',$cli_id)->get();
            }
            else{
                $payments = $query->get();
            } */
            try{
            $query = CustomerClientPayment::/* whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                    ->or */Where('customer_cust_id',$id)->where('client_pay_tracking',0);
            //get payments for batch
            $payments = EloquentBuilder::to($query, $request->all())->orderBy('client_pay_id','DESC')->get();
            } catch (NotFoundFilter $e) {
            abort(404, $e->getMessage());
            }
            $failed = CustomerClientPayment::/* whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                    ->or */Where('customer_cust_id',$id)->where('client_pay_status',2)->orderBy('client_pay_id','DESC')->get();
            $successful = CustomerClientPayment::where('client_pay_status',1)->/* whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                            ->or */Where('customer_cust_id',$id)->orderBy('client_pay_id','DESC')->get();
            $rejected = CustomerClientPayment::where('client_pay_status',3)->/* whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                        ->or */Where('customer_cust_id',$id)->orderBy('client_pay_id','DESC')->get();
        }
        catch (Exception $e) {
            abort(500, $e->getMessage());
        }
        }
        else if(Auth::user()->user_type == 'organization')
        {
            try
            {
            //get customer id
            $id = Auth::user()->bulk_cust_id;
            $batches = ClientBatch::where('client_batch_customer_id',$id)->get();
            $mygroups = CustomerGroup::where('customer_cust_id',$id)->get();
            $mypaybills=BusinessNumber::where('business_customer_id',$id)->get();
            //get customer clients
            $clients = CustomerClient::where('customer_cust_id',$id)->pluck('cust_client_id');
            $client_batchs = ClientBatch::where('client_batch_customer_id',$id)->pluck('id');
            //get customer payments
            $query = CustomerClientPayment::/* whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                    ->or */where('customer_cust_id',$id)->where('client_pay_tracking',0);
            $payments = EloquentBuilder::to($query, $request->all())->get();
            
            $failed = CustomerClientPayment::/* whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                    ->or */where('customer_cust_id',$id)->where('client_pay_status',2)->get();
            $successful = CustomerClientPayment::where('client_pay_status',1)->/* whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                        ->or */where('customer_cust_id',$id)->get();
            $rejected = CustomerClientPayment::where('client_pay_status',3)->/* whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)
                        ->or */Where('customer_cust_id',$id)->get();
            } catch (Exception $e) {
            abort(500, $e->getMessage());
            }
        }
        else
        {
            $batches = ClientBatch::all();
            $mygroups = CustomerGroup::all();
            $mypaybills=BusinessNumber::all();
            // $payments = CustomerClientPayment::all();
            $query = CustomerClientPayment::where('client_pay_status',0);
            $payments = EloquentBuilder::to($query, $request->all())->get();
            $failed = CustomerClientPayment::where('client_pay_status',2)->get();
            $successful = CustomerClientPayment::where('client_pay_status',1)->get();
            $rejected = CustomerClientPayment::where('client_pay_status',3)->get();
        }
        $transactions = CustomerWalletTransaction::all();
        
         return view('bmviews.payments.index',compact('transactions','payments','id','failed','successful','mygroups','mypaybills','batches','rejected'));
    // return response()->json($transactions);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('payments.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    //pay client
    public function payClient(Request $request)
    {
        //
        ///if user status == 0 refuse request\
       if(Auth::user()->cust_user_status == 1)
       {
            request()->validate([
                'client' => 'required',
                'amount' => 'required|integer'
            ],
            [
                'amount.integer' => 'Amount must be a number[e.g 9999]'
                ]);
            //insert
            //generate batch id
            $todaydate = date('Ymd');
            //get maximum batch id
            $maxBatch = CustomerClientPayment::where('customer_cust_id',Auth::user()->customer_cust_id)->max('client_pay_batch_id');
            
            // dd($maxBatch);
            if($maxBatch){
                $batch = $maxBatch + 1;
            }
            else{
                $batch = Auth::user()->customer_cust_id. $todaydate . 1;
            }
            $clients = $request->client;
            $returned_payees=[];
            foreach($clients as $client){
                // //check pending for contact
                // $check = CustomerClientPayment::where('customer_cust_id',Auth::guard('web')->user()->customer_cust_id)->where('customer_client_cust_client_id',$client['cust_client_id'])->where('client_pay_tracking',0)->with('ClientPaymentClient')->get();
                
                // if(!$check->count())
                // {

                    $pay = new CustomerClientPayment();
                    
                    $pay->customer_client_cust_client_id = $client['cust_client_id'];
                    $pay->client_pay_amount = $request->amount;
                    $pay->client_type="B2C";
                    $pay->client_pay_batch_id = $batch;
                    $pay->customer_cust_id = Auth::user()->customer_cust_id; //added by Dennis
                    //log
                    $payLog = new AuditLog();
                    $payLog->audit_module = "User";
                    $payLog->audit_activity = "Payment made to payee#: ".$client['cust_client_id'] ." by user ID# " .Auth::user()->cust_user_id;
                    $payLog->user_category = "User";
                    $payLog->user_id = Auth::user()->cust_user_id; 
                    $pay->save();
                    $payLog->save();
                    
                    //log
                      $module=$payLog->audit_module;$activity=$payLog->audit_activity;$user_category=$payLog->user_category;$user_id=$payLog->user_id;$datetime=date('Y-m-d h:i:s');
       
                        $list = array (
                        array($module, $activity,  $user_category,$user_id, $datetime),
                        );
                        
                        $file = fopen("csvs/Initiate.csv","a+");
                        
                        foreach ($list as $line) {
                        fputcsv($file, $line);
                        }
                        
                        fclose($file);
                        // end write to csv
                    array_push($returned_payees,$pay);
                // }
                // else
                // {
                //     $check_arr= [];
                //    foreach($check as $check){
                //        array_push($check_arr,$check->ClientPaymentClient->cust_client_fullname);
                //    }
                //     return response()->json(["errors"=>["client"=>[" Pending payments already exists for clients: ".json_encode($check_arr)]]],422);
                // }
            
            }

            //send a supervision message to the customer initiated by customer user
            if(!empty($returned_payees)){
                $smsobject=new Mobisky('twalisha','twalisha');
                //get the phone number of the customer
                $cust_id=Auth::user()->customer_cust_id;
                $cust_omer=Customer::find($cust_id);
                $sms="Dear Customer, a new initiation has been done by User ".Auth::user()->cust_user_surname;

                // $textstatus=$smsobject->sendMessage("254".$cust_omer->cust_primary_contact_type,$sms);
            }
            return $returned_payees;
        }
        {
            return redirect()->route('customer.login')->with('failure','Sorry! Your account is inactive.');
        }    
        
    }
   //pay Business
   public function payBusiness(Request $request)
   {
       //
       ///if user status == 0 refuse request\
       if(Auth::user()->cust_user_status == 1)
       {
        request()->validate([
            'number' => 'required|integer',
            'account' => 'required',
            'remarks' => 'required',
            'amount' => 'required|integer'
            ],
            [
                'amount.integer' => 'Amount must be a number[e.g 9999]',
            'number.integer' => 'Business/Till No. must be a number',
        ]);
        //generate batch id
        $todaydate = date('Ymd');
        //get maximum batch id
        $maxBatch = CustomerClientPayment::where('customer_cust_id',Auth::user()->customer_cust_id)->max('client_pay_batch_id');
        // dd($maxBatch);
        if($maxBatch){
            $batch = $maxBatch + 1;
        }
        else{
            $batch = Auth::user()->customer_cust_id. $todaydate . 1;
        }
        //insert
        $number = $request->number;
        $amount = $request->amount;
        $account = $request->account;
        $remarks = $request->remarks;
        $customer = $request->customer_id;
            $pay = new CustomerClientPayment();
            $pay->client_pay_amount = $amount;
            $pay->client_pay_batch_id = $batch;
            $pay->client_b2b_number = $number;
            $pay->client_pay_account_name = $account;
            $pay->client_pay_remarks = $remarks;
            $pay->client_type='B2B';
            $pay->customer_cust_id = Auth::user()->customer_cust_id;//added by Dennis 
            //log
            $payLog = new AuditLog();
            $payLog->audit_module = "User";
            $payLog->audit_activity = "Payment made to Business#: ".$number ." by user ID# " .Auth::user()->cust_user_id;
            $payLog->user_category = "User";
            $payLog->user_id = Auth::user()->cust_user_id; 
            //$pay->save();
            $payLog->save();
            
             //log
                      $module=$payLog->audit_module;$activity=$payLog->audit_activity;$user_category=$payLog->user_category;$user_id=$payLog->user_id;$datetime=date('Y-m-d h:i:s');
       
                        $list = array (
                        array($module, $activity,  $user_category,$user_id, $datetime),
                        );
                        
                        $file = fopen("csvs/Initiate.csv","a+");
                        
                        foreach ($list as $line) {
                        fputcsv($file, $line);
                        }
                        
                        fclose($file);

            if($pay->save()){
                $smsobject=new Mobisky('twalisha','twalisha');
                //get the phone number of the customer
                $cust_id=Auth::user()->customer_cust_id;
                $cust_omer=Customer::find($cust_id);
                $sms="Dear Customer, a new initiation has been done by User ".Auth::user()->cust_user_surname;

                // $textstatus=$smsobject->sendMessage("254".$cust_omer->cust_primary_contact_type,$sms);
            }
        
        return $pay . $payLog;
       }
       {
        return redirect()->route('customer.login')->with('failure','Sorry! Your account is inactive.');
       }
       
   }
    //editpay client
    public function editPayClient(Request $request)
    {
        //
        request()->validate([
            'client' => 'required',
            'reason' => 'required',
            'amount' => 'required'
            ]);
        //insert
        
            $pay = CustomerClientPayment::find($request->client_pay_id);
            $pay->customer_client_cust_client_id = $request->client['cust_client_id'];
            $pay->client_pay_amount = $request->amount;
            $pay->client_type='B2C';
            //log
            $payLog = new AuditLog();
            $payLog->audit_module = "User";
            $payLog->audit_activity = "Payment made to payee#: ".$request->client['cust_client_id'] ." edited to ".$pay." with reason [".$request->reason."] by user ID# " .Auth::user()->cust_user_id;
            $payLog->user_category = "User";
            $payLog->user_id = Auth::user()->cust_user_id; 
            
            
            
            $pay->save();
            $payLog->save();
            
             //log
                      $module=$payLog->audit_module;$activity=$payLog->audit_activity;$user_category=$payLog->user_category;$user_id=$payLog->user_id;$datetime=date('Y-m-d h:i:s');
       
                        $list = array (
                        array($module, $activity,  $user_category,$user_id, $datetime),
                        );
                        
                        $file = fopen("csvs/Initiate.csv","a+");
                        
                        foreach ($list as $line) {
                        fputcsv($file, $line);
                        }
                        
                        fclose($file);
            
            return $pay;
            
    }
    //pay group
    public function payGroup(Request $request)
    {
        //
        request()->validate([
            'myGroup' => 'required',
            'amount' => 'required|integer'
        ],
        [
            'myGroup.required' => 'Please select a group.',
            'amount.integer' => 'Amount must be a number[e.g 9999]'
            ]);
        ///if user status == 0 refuse request\
        if(Auth::user()->UserCustomer->cust_status == 1)
        {
            if(Auth::user()->cust_user_status == 1)
            {
                //generate batch id
                $todaydate = date('Ymd');
                //get maximum batch id
                $maxBatch = CustomerClientPayment::where('customer_cust_id',Auth::user()->customer_cust_id)->max('client_pay_batch_id');
                // dd($maxBatch);
                if($maxBatch){
                    $batch = $maxBatch + 1;
                }
                else{
                    $batch = Auth::user()->customer_cust_id. $todaydate . 1;
                }
                //insert
                $grpid = $request->myGroup;
                $extend = function($query) { $query->where('cust_client_status', '=', '1'); };
                $groupCLients = CustomerClientGroup::where('customer_group_cust_group_id',$grpid['cust_group_id'])->whereHas('ClientGroupClient',$extend)->pluck('customer_client_cust_client_id');

                $groupees = [];
                foreach($groupCLients as $client)
                {
                    $pay = new CustomerClientPayment();
                    $pay->customer_client_cust_client_id = $client;
                    
                    $pay->client_pay_amount = $request->amount;
                    $pay->client_type ='B2C';
                    $pay->client_pay_batch_id = $batch;
                    $pay->customer_cust_id = Auth::user()->customer_cust_id; //added by Dennis
                    // log
                    $payLog = new AuditLog();
                    $payLog->audit_module = "User";
                    $payLog->audit_activity = "Payment to group#  made to payee: " .$pay." by user ID# " .Auth::user()->cust_user_id;//" of Kes.".$request->amount." made to payee# : ".$client ." by user ID# " .Auth::guard('web')->user()->cust_user_id;
                    $payLog->user_category = "User";
                    $payLog->user_id = Auth::user()->cust_user_id;
                    
                    $pay->save();
                    $payLog->save();
                    
                    //log
                    $module=$payLog->audit_module;$activity=$payLog->audit_activity;$user_category=$payLog->user_category;$user_id=$payLog->user_id;$datetime=date('Y-m-d h:i:s');
    
                        $list = array (
                        array($module, $activity,  $user_category,$user_id, $datetime),
                        );
                        
                        $file = fopen("csvs/Initiate.csv","a+");
                        
                        foreach ($list as $line) {
                        fputcsv($file, $line);
                        }
                        
                        fclose($file);
                                
                    array_push($groupees,$pay);
                }
    
                //send a supervision message to the customer initiated by customer user
                if(!empty($groupees)){
                    $smsobject=new Mobisky('twalisha','twalisha');
                    //get the phone number of the customer
                    $cust_id=Auth::user()->customer_cust_id;
                    $cust_omer=Customer::find($cust_id);
                    $sms="Dear Customer, a new initiation has been done by User ".Auth::user()->cust_user_surname;
    
                    // $textstatus=$smsobject->sendMessage("254".$cust_omer->cust_primary_contact_type,$sms);
                }
                return $groupees;
            }
            else
            {
                return redirect()->route('login')->with('failure','Sorry! Your account is inactive.');
            }
        }
        else
        {
            return redirect()->route('login')->with('failure','Sorry! Your organization account is inactive.');
        }
        // 
        
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return view('bmviews.payments.details');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        return view('bmviews.payments.edit');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroyPayment($id)
    {
        //
        $data = CustomerClientPayment::where('client_pay_id',$id)->delete();
        //$data->delete();
        return $data;

    }
    //reject payment
    public function rejectPayment($id)
    {
        $data = CustomerClientPayment::findOrFail($id);
        $data->client_pay_status = '3';
        $data->client_pay_tracking = '1';
        $data->save();
        return $data;

    }
    //retry payment
    public function retryPayment($id)
    {
        $data = CustomerClientPayment::findOrFail($id);
        $data->client_pay_status = '0';
        $data->client_pay_tracking = '0';
        $data->save();
        return $data;

    }
    //get logged in user clients
    public function getMyClients()
    {
        if(Auth::user()->user_type == 'organization_user'){
             $id = Auth::user()->customer_cust_id;
        $data = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->get();
        }
        else if(Auth::user()->user_type == 'organization'){
            $id = Auth::user()->bulk_cust_id;
        $data = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->get(); 
        }
        else{
             
             $data = NULL;
        }
       
        return $data;
    }
    //get logged in user grouos
    public function getMyGroups()
    {
       
        
        if(Auth::user()->user_type == 'organization_user'){
           $id = Auth::user()->customer_cust_id;
           $data = CustomerGroup::where('customer_cust_id',$id)->where('cust_group_status',1)->get();
        }
        elseif(Auth::user()->user_type == 'organization'){
             $id = Auth::user()->cust_id;
             $data = CustomerGroup::where('customer_cust_id',$id)->where('cust_group_status',1)->get();
        }
        else{
             
             $data = NULL;
        }
        return $data;
    }
    
     //get logged in user paybills
    public function getMyPaybills()
    {
       
        
        if(Auth::user()->user_type == 'organization_user'){
           $id = Auth::user()->customer_cust_id;
        $data = BusinessNumber::where('business_customer_id',$id)->where('business_number_status',1)->get();
        }
        elseif(Auth::user()->user_type == 'organization'){
             $id = Auth::user()->cust_id;
             $data = BusinessNumber::where('business_customer_id',$id)->where('business_number_status',1)->get();
        }
        else{
             
             $data = NULL;
        }
        return $data;
    }
    
    public function getAllClients(){
       
        //
        if(Auth::user()->user_type == 'organization_user'){
              $id = Auth::user()->customer_cust_id;
              $c=array();
              if(Auth::user()->shop_id){
                    
                    $customer_id=Auth::user()->userShopUser['customer_id'];
                    $airtimecontacts=Airtime_contact::where('customer_id',$customer_id)->get(['contact AS cust_client_phone','fname AS cust_client_fullname','contact_id AS cust_client_id'])->toArray();
               
                    
                    foreach($airtimecontacts as $a){
                    $air_c['cust_client_phone']=substr($a['cust_client_phone'],-9);
                    $air_c['cust_client_fullname']=$a['cust_client_fullname'];
                    $air_c['cust_client_id']=$a['cust_client_id'];
                    array_push($c,$air_c);
                
                }
                  
                }
                
                
              
             $fcuser_id = Auth::user()->organization_id;
        $data = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->get(['cust_client_phone','cust_client_fullname','cust_client_id'])->toArray();
        $contacts=Contact::where('organization_id',$fcuser_id)->get(['phone AS cust_client_phone','name AS cust_client_fullname','contact_id AS cust_client_id'])->toArray();
       
        foreach($contacts as $a){
            $b['cust_client_phone']=substr($a['cust_client_phone'],-9);
            $b['cust_client_fullname']=$a['cust_client_fullname'];
            $b['cust_client_id']=$a['cust_client_id'];
            array_push($c,$b);
        
        }
        
        $newdata=array_merge($data,$c);
        
        }
        else if(Auth::user()->user_type == 'organization'){
            $id = Auth::user()->bulk_cust_id;
            
             $c=array();
              if(Auth::user()->shop_id){
                    
                    $customer_id=Auth::user()->userShopUser['customer_id'];
                    $airtimecontacts=Airtime_contact::where('customer_id',$customer_id)->get(['contact AS cust_client_phone','fname AS cust_client_fullname','contact_id AS cust_client_id'])->toArray();
               
                    
                    foreach($airtimecontacts as $a){
                    $air_c['cust_client_phone']=substr($a['cust_client_phone'],-9);
                    $air_c['cust_client_fullname']=$a['cust_client_fullname'];
                    $air_c['cust_client_id']=$a['cust_client_id'];
                    array_push($c,$air_c);
                
                }
                  
                }
            
        $fcorg_id = Auth::user()->organization_id;
        $data = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->get(['cust_client_phone','cust_client_fullname','cust_client_id'])->toArray();
        $contacts=Contact::where('organization_id',$fcorg_id)->get(['phone AS cust_client_phone','name AS cust_client_fullname','contact_id AS cust_client_id'])->toArray();
     
        foreach($contacts as $a){
            $b['cust_client_phone']=substr($a['cust_client_phone'],-9);
            $b['cust_client_fullname']=$a['cust_client_fullname'];
            $b['cust_client_id']=$a['cust_client_id'];
            array_push($c,$b);
        
        }
        
        $newdata=array_merge($data,$c);
        }
        else{
             
             $newdata = NULL;
        }
       
        return $newdata;
        
        
    }
}
