<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;
use Auth;
use App\Charts\BMCharts\CustomerChart;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\CustomerWalletTransaction;
use App\Models\bmmodels\CustomerClientPayment;
use App\Models\bmmodels\CustomerClient;
use App\Models\bmmodels\CustomerUser;
use App\Models\bmmodels\ClientBatch;
use App\Models\bmmodels\CustomerWallet;
use App\Models\bmmodels\AuditLog;
use Log;

class CustController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
  
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    { 
        $today = date('Y-m-d');
        if(Auth::user()->user_type == 'organization'){
             
            if(Auth::user()->cust_status == 1)
            {
                   
                      
                $id = Auth::user()->cust_id;
                //get customers
                $users = CustomerUser::where('customer_cust_id',$id)->count();
                $myclients = CustomerClient::where('customer_cust_id',$id)->where('cust_client_status',1)->count();
                $mybatches = ClientBatch::where('client_batch_customer_id',$id)->groupBy('client_batch_id')->count();
                
                //get wallet id
                $wallet = CustomerWallet::where('customer_cust_id',$id)->pluck('cust_wallet_id');
                $clients = CustomerClient::where('customer_cust_id',$id)->pluck('cust_client_id');
                $client_batchs = ClientBatch::where('client_batch_customer_id',$id)->pluck('id');
                //get total income and expenditure
                $income = 0;
                $today_income = 0;
                if($wallet->count())
                {
                   $income = CustomerWalletTransaction::where('cust_wallet_cust_wallet_id',$wallet[0])->where('wallet_trans_status',1)->sum('wallet_trans_amount');
                   $today_income = CustomerWalletTransaction::where('cust_wallet_cust_wallet_id',$wallet[0])->where('wallet_trans_status',1)->where('created_at','LIKE',$today."%")->sum('wallet_trans_amount'); 
                }
                
                $expenditure = CustomerClientPayment::whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)->orWhere('customer_cust_id',$id)->where('client_pay_status', 1)->sum('client_pay_amount');
                $today_expenditure = CustomerClientPayment::where('client_pay_status', 1)->where('created_at','LIKE',$today."%")->whereIn('customer_client_cust_client_id',$clients)->orWhereIn('customer_client_batch_id',$client_batchs)->orWhere('customer_cust_id',$id)->sum('client_pay_amount');
                //chart
                $total = $income+$expenditure;
        
                $borderColors = [ "#30ba35", "#f25961" ];
                $fillColors = [ "#5ad85e", "#f57a81" ];
                
                $chart = new CustomerChart;
                $chart->minimalist(true);
                        $chart->labels(['Income','Spend']);
                        $chart->dataset('Income & Expenditure', 'doughnut',[$income,$expenditure])
                        ->color($borderColors)
                        ->backgroundcolor($fillColors);
                return view('bmviews.customer-dashboard',compact('income','expenditure','users','myclients','mybatches','today_income','today_expenditure'),['chart' => $chart]);
            }
            else{
                return redirect()->route('customer.login')->with('failure','Sorry! Your account is inactive');
            }
       
        }
        else{
            return redirect()->route('customer.login');
        }
    }
    //get my users
    public function getUsers()
    {
        $id = Auth::user()->cust_id;
        $data = CustomerUser::where('customer_cust_id',$id)->get();
        return $data;
    }
    //get my user activity count
    public function getActivity($id)
    {
        $today = date('Y-m-d');
        $data = AuditLog::where('user_id',$id)->where('created_at',$today."%")->count();
        return $data;
    }
}
