@php
if(Auth::guard('web')->check())
{
    $layout = 'layouts.user';
    $dashboard='user-dashboard';
    $fdashboard='user-dashboard';
}
elseif(Auth::guard('admin')->check())
{
 $layout = 'layouts.admin';
 $dashboard='admin-dashboard';
 $fdashboard='admin-dashboard';
 }
 elseif(Auth::guard('customer')->check())
 {
 $layout = 'layouts.customer';
 $dashboard='customer-dashboard';
 $fdashboard='customer-dashboard';

 }
@endphp
@extends($layout)
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Contacts</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="{{ route($fdashboard)}}">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    @if(Auth::guard('admin')->check())
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="{{ route('customers.index') }}">Customers</a>
                                    </li>
                                    @endif
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="{{ route('clients.index',$CustomerClients->customer_cust_id) }}">Contacts</a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">View Contact</a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="{{ route('clients.index',$CustomerClients->customer_cust_id) }}" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        </div>
                    </div>
                </div>
                <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Contact Details</div>
                                        <div class="form-group row">
                                                    <div class="col-md-6">
                                                        <label for="">Fullname</label>
                                                        <input type="text" name="cust_client_fullname" value="{{ $CustomerClients->cust_client_fullname}}" class="form-control"disabled placeholder="Enter Contacts fullname...">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label for=""> IDNo(s)</label>
                                                        <input type="text" name="admin_othername" value="{{ $CustomerClients->cust_client_idno}}" class="form-control"disabled placeholder="Enter Contacts IDNo...">
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <div class="col-md-6">
                                                     <label for=""> Status </label>
                                                     @if($CustomerClients->cust_client_status=='0')
                                                        <input type="text" name="cust_client_status"  value="Inactive" class="form-control"disabled placeholder="Enter  cust_client_status ...">                                                        
                                                     @elseif($CustomerClients->cust_client_status=='1')
                                                     <input type="text" name="cust_client_status"  value="Active" class="form-control"disabled placeholder="Enter  cust_client_status ...">                                                        
                                                   
                                                     @endif
                                                    </div>
                                                   
                                                    </div>
                                    </div>
                                </div>
                            </div>
                        </div>
            </div>
            </div>
        </div>
    </div>
    @endsection