<?php

namespace App\Models\fcmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class OrganizationUser extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $connection = 'mysql_newfc';
    // protected $table = 'users';
    protected $primaryKey = 'user_id';
    protected $table = 'organization_users';
    protected $fillable = [
        'user_id', 
        'fname', 
        'lname', 
        'email',
        'role_id', 
        'username', 
        'password',
        'organization_id',
        'department_id',
        'status',
    ];


    protected $hidden = [
        'password',
        'remember_token',
    ];

    //orguser-org rlshp
    public function userOrg()
    {
        return $this->belongsTo(Organization::class,'organization_id');
    }
    //orguser ---  dept rlshp
    public function userDept()
    {
        return $this->belongsTo(Department::class,'department_id');
    }
    //orguseruser-role rlshp
    public function userRole()
    {
        return $this->belongsTo(Role::class,'role_id');
    }
    public function userOrgUser()
    {
        // return fcmodels\OrganizationUser::where('email',$this->email)->where('organization_id',$this->cust_id)->get();
        return $this->hasOne(User::class, 'email');
    }
}
