<?php

namespace App\Models\fcmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Http; // Import the Http facade
use App\Events\MessageDeliveryCreated; // Import the MessageDeliveryCreated event

class MessageDelivery extends Model
{
        protected $connection = 'mysql_newfc';

    protected $primaryKey = 'message_delivery_id';
    protected $table = 'messagedelivery';
  
    protected $fillable = [
        'message_delivery_id',
        'doneDate',
        'errorCode',
        'messageId',
        'shortMessage',
        'status',
        'submitDate',
        'mobile',
    ];    

    //group<>Org relationship
    public function ShopOrg()
    {
        return $this->belongsTo(Organization::class,'organization_id');
    }
    
      
// protected $dispatchesEvents = [
//         'created' => MessageDeliveryCreated::class . '@handle', // Specify the method to be called
//     ];
 
}
