<?php

namespace App\Models\bmmodels;

use Illuminate\Database\Eloquent\Model;

class CustomerAuth extends Model
{
    //
    protected $connection = 'mysql_bmp';
    protected $fillable = [
        'cust_auth_id',
        'otp',
        'otp_status',
        'otp_created',
        'otp_expired',
        'customer_user_cust_user_id',
        'customer_cust_id',
        'sms'
    ];
    //auth<>user relationship
    public function AuthUser()
    {
        return $this->belongsTo(CustomerUser::class, 'customer_user_cust_user_id','cust_user_id');
    }
    //auth<>customer relationship
    public function AuthCustomer()
    {
        return $this->belongsTo(Customer::class, 'customer_cust_id','cust_id');
    }
}
