<?php

namespace App\Http\Controllers\FCControllers;

use App\Models\fcmodels\Option;
use App\Models\fcmodels\Question;
use App\Models\fcmodels\Wallet;
use Illuminate\Http\Request;
use Auth;

class OptionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    //return options view
    public function index($id)
    {
        if(Auth::check())
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
       
        else{
            return abort('401');
        }
        $question = Question::findOrFail($id);
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        $options = Option::where('question_id',$question['id'])->get();
        
        return view('fcviews.options.index',compact('options','question','wallet'));
    }

    public function store(Request $request)
    {
        //
        $request->validate([
            'option' => 'required',
            'response' => 'required',
        ]);
        $option = new Option();
        $option->option = $request->option;
        $option->response = $request->response;
        $option->question_id = $request->question;
        $option->save();
    }

    public function update(Request $request)
    {
        $request->validate([
            'option' => 'required',
            'response' => 'required',
        ]);
        $option = Option::findOrFail($request->id);
        $option->option = $request->option;
        $option->response = $request->response;
        $option->save();
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Option  $option
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
    
       // $option = Option::findOrFail($request->id);
        //$option->delete();
        
         //find user details to delete
    $admin = Option::where('id',$id)->get();
    //set delete
    $deleteoption = Option::find($id);
    $deleteoption->delete();
    //set logging
    
        $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Questions options: ".$admin." deleted by Admin ID#" .$id;
    
    $adminLog->user_category = "organization";
    $adminLog->user_id = $id; 
    $adminLog->save();
    
    }
}
