<?php

namespace App\Http\Controllers\FCControllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Model;
use Auth;
use App\Http\Controllers\CustomerOtpController;
use Illuminate\Support\Facades\DB;
use DateTime;
use App\Models\fcmodels\Organization;
use Hash;

class OrganizationLoginController extends Controller
{
    public function __construct()
    {
        //defining our middleware for this controller
        $this->middleware('guest:organization',['except' => ['logout']]);
    }
    //function to show login form
    public function showLoginForm() {
        return view('auth.organization-login.login');
    }
    //function to login 
    public function login(Request $request) {
        $data=[];
         //validate the form data
         $request->validate([
            'username' => 'required',
            'password' => 'required|min:6'
        ]);
        //check database connection and handle the exception
     try{
            $db=DB::connection();   
            
            if($db){ 
                if (Auth::guard('organization')->attempt(['username' => $request->username, 'password' => $request->password], $request->remember)){
            
                 $organizations=Organization::where('organization_id',Auth::guard('organization')->user()->organization_id)->get();
                
                 //get username and password for mobisky sms api
             
                 $data=["status"=>"organizationsuccess"];   
            } 
           
            }  
            else{
                $data=["status"=>"organizationfailed"];
                
            } 
         
         }
        catch(\Exception $e) {

            return abort('504', 'Could not connect to the database.  Please check your configuration.'.$e);
            
        } 
        return response()->json($data); 
    }

    public function logout()
    {
        Auth::guard('organization')->logout();

        return redirect('/organizations/login');
    }

 
}