<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;
use Auth;
use App\Models\bmmodels\BusinessNumber;
use App\Models\bmmodels\B2BRate;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\B2BTariff;
use Illuminate\Database\Eloquent\Builder;
class BusinessNosController extends Controller
{
    //return view
    public function index($id)
    {
        if(Auth::user()->user_type == 'organization')
        {
            $businessnos = BusinessNumber::with('B2BTariff')->where('business_customer_id',$id)->get();
            $customer=Customer::where('cust_id',$id)->first();
            $customer_name=$customer['cust_name'];
            $b2btariffs = B2BTariff::all();
              
        }
        else 
        {
            $businessnos = BusinessNumber::with('B2BTariff')->where('business_customer_id',$id)->get();
            $customer=Customer::where('cust_id',$id)->first();
            $customer_name=$customer['cust_name']; 
            $b2btariffs = B2BTariff::all();
        }
        
        return view('bmviews.businessnos.index',compact('businessnos','id','b2btariffs','customer_name'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'business_number'=>'required',
            'account_name'=>'required',
            'tariff_id'=>'required',
        ]);
        
        $busno = new BusinessNumber();
        $busno->business_number = $request->business_number;
        $busno->account_name = $request->account_name;
        $busno->tariff_id = $request->tariff_id;
        $busno->business_customer_id = $request->business_customer_id;
        $busno->business_number_status = '1';
        $busno->save();
        return back()->with('success','Paybill/Till Added succesfully');
        
    }
    
    public function update(Request $request)
    {
        $request->validate([
            'business_number'=>'required',
            'account_name'=>'required',
            'tariff_id'=>'required',
        ]);
        $busno = BusinessNumber::findOrFail($request->id);
        $busno->business_number = $request->business_number;
        $busno->account_name = $request->account_name;
        $busno->tariff_id = $request->tariff_id;
        $busno->business_customer_id = $request->business_customer_id;
        $busno->business_number_status = $request->has('business_number_status') ? 1 : 0;;
        $busno->save();
        
    
        
        return back()->with('success','Business Number updated succesfully');
    }
     /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
      
        //find customer details before delete
        $CustomerClient = BusinessNumber::where('business_number_id',$id)->get();
        //set delete
        $deleteCustomerClient = BusinessNumber::find($id);
       
        $deleteCustomerClient->delete();
        
        //return message
        return redirect()->back()
            ->with('success','Business Number  Deleted Succesfully.');
        
           
    }
}
