<?php

namespace App\Http\Controllers\BMControllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Model;
use Auth;
use App\Models\TestAuth;
use App\Models\CustomerAuth;
use App\Http\Controllers\CustomerOtpController;
use Illuminate\Support\Facades\DB;
use DateTime;
use App\Libs\Mobisky;
use App\Models\Customer;
use Hash;
use Log;

class CustomerLoginController extends Controller
{
    public function __construct()
    {
        //defining our middleware for this controller
        $this->middleware('guest:customer',['except' => ['logout']]);
    }
    //function to show admin login form
    public function showLoginForm() {
        return view('auth.customer-login.login');
    }
    //function to login admins
    public function login(Request $request) {
        $data=[];
         //validate the form data
         $this->validate($request,[
            'username' => 'required',
            'password' => 'required|min:6'
        ]);
        //check database connection and handle the exception
     try{
            $db=DB::connection();   
            
            if($db){ 
                if (Auth::guard('customer')->attempt(['cust_username' => $request->username, 'password' => $request->password], $request->remember)){
                    
                    
            
                 $customers=Customer::where('cust_id',Auth::guard('customer')->user()->cust_id)->get();
                
                 //get username and password for mobisky sms api
                 $mobiskysms=app('App\Http\Controllers\ServiceCredentialController')->mobiskySettings();
                
                     //read the values from the settings after db mapping
                     $sms_username=\Config::get('outpost.sms_username');
                     $sms_password=\Config::get('outpost.sms_password'); 

                         $smsobject=new Mobisky('twalisha','twalisha');
 
                         $phn="254".Auth::guard('customer')->user()->cust_primary_contact_type;
                         $otp_code=strtoupper(substr(Hash::make($smsobject->codeGenerator(6)),4,6));
                         $otp=$otp_code."0";
                         $otp_status=0;
                         $otp_created=new DateTime();
                         $customer_user_cust_user_id=Auth::guard('customer')->user()->cust_id;
                        
                        
                        $sms="Verification code: ".$otp;
                        
                        $textstatus='test';
                        $textstatus=$smsobject->sendMessage($phn,$sms);
                        DB::table('customer_auths')->insert(['otp'=>$otp,'sms'=>'hello','otp_status'=>$otp_status,'otp_created'=>$otp_created,'customer_cust_id'=>$customer_user_cust_user_id]);
                        $id = Auth::guard('customer')->user()->cust_id; 
                        DB::table('customers')->where('cust_id',$id)->update(['cust_otp_status' => '0']);
                    
                                
              
                        $data=["status"=>"customersuccess","textstate"=>$textstatus];   
                } 
           
            }  
            else{
                $data=["status"=>"customerfailed","textstate"=>$textstatus];
                
            } 
         
         }
        catch(\Exception $e) {

            return abort('504', 'Could not connect to the database.  Please check your configuration.'.$e);
            
        } 
        return response()->json($data); 
    }

    public function logout()
    {
        Auth::guard('customer')->logout();

        return redirect('/customer/login');
    }

 
}