<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;
use Auth;
use App\Charts\BMCharts\AdminChart;
use App\Models\bmmodels\Customer;
use App\Models\bmmodels\ClientBatch;
use App\Models\bmmodels\CustomerUser;
use App\Models\bmmodels\CustomerWalletTransaction;
use App\Models\bmmodels\CustomerClientPayment;
use App\Models\bmmodels\CustomerClient;
use App\Models\bmmodels\CustomerWallet;

class AdminController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('auth:admin');
    // }
     
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try
        {        
            $today = date('Y-m-d');
            
            //chart
            $income = CustomerWalletTransaction::where('wallet_trans_status',1)->sum('wallet_trans_amount');
            $expenditure = CustomerClientPayment::where('client_pay_status', 1)->sum('client_pay_amount');
            $total = $income+$expenditure;

            $borderColors = [ "#30ba35", "#f25961" ];
            $fillColors = [ "#5ad85e", "#f57a81" ];
            
            $chart = new AdminChart;
            $chart->minimalist(true);
                    $chart->labels(['Income','Spend']);
                    $chart->dataset('Income & Expenditure', 'doughnut',[$income,$expenditure])
                    ->color($borderColors)
                    ->backgroundcolor($fillColors);
            //get customers
            $customers = Customer::count();
            $a_customers = Customer::where('cust_status',1)->count();
            $i_customers = Customer::where('cust_status',0)->count();
            
            //get total income and expenditure
            $income = CustomerWalletTransaction::where('wallet_trans_status',1)->sum('wallet_trans_amount');
            $today_income = CustomerWalletTransaction::where('wallet_trans_status',1)->where('created_at','LIKE',$today."%")->sum('wallet_trans_amount');
            $expenditure = CustomerClientPayment::where('client_pay_status', 1)->sum('client_pay_amount');
            $today_expenditure = CustomerClientPayment::where('client_pay_status', 1)->where('created_at','LIKE',$today."%")->sum('client_pay_amount');
            
            return view('bmviews.admin-dashboard',compact('income','expenditure','customers','a_customers','i_customers','today_income','today_expenditure','chart')/* ['chart' => $chart] */);
        }
        catch(Exception $e)
        {
            abort(500, $e->getMessage());   
        }
    }
    public function getCustomers()
    {
        $data = Customer::all();
        return $data;
    }
    public function getUsers($id)
    {
        $data = CustomerUser::where('customer_cust_id',$id)->count();
        return $data;
    }
    public function getClients($id)
    {
        $data = CustomerClient::where('customer_cust_id',$id)->count();
        return $data;
    }
    public function getBatches($id)
    {
        $data = ClientBatch::where('client_batch_customer_id',$id)->count();
        return $data;
    }
    public function testroute(){
        return "testing this";
    }

}
