<?php
namespace App\Classes\FCClasses;

use Illuminate\Support\Facades\Auth;
use App\Models\fcmodels\APIUser;
use App\Models\fcmodels\Shop;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\CountryRate;

class SendSms
{
    private $url = "https://api.onfonmedia.co.ke/v1/sms/SendBulkSMS";
    private $senderId;
    private $apiKey   = "tjpX6UMmG5Rfnd8txO14nK8rsTBkxR1OtHzKjvYPr3Y=";
    private $clientId = "9e47b51d-5bc8-4b49-82d6-512e393f3323";

    public function __construct()
    {
        if (Auth::check()) {
            $apiAccountId = Auth::user()->api_account;

            // get APIUser
            $apiUser = APIUser::where('shop_id', $apiAccountId)->first();

            if ($apiUser) {
                // use shop_id from APIUser to get Shop record
                $shop = Shop::find($apiUser->shop_id);

                if ($shop && $shop->sms_name) {
                    $this->senderId = $shop->sms_name;
                } else {
                    // fallback if no shop or no sms_name
                    $this->senderId = "GAPTECH";
                }
            } else {
                $this->senderId = "GAPTECH";
            }
        } else {
            abort(401, "Unauthorized");
        }
    }



public function sendMessage($phone, $message)
{
    // Fetch current authenticated API user
    $apiUser = APIUser::where('shop_id', Auth::user()->api_account)->first();

    if (!$apiUser) {
        return "Failed: Invalid API credentials";
    }

    $username = $apiUser->username;
    $password = $apiUser->password;

    if (substr($phone, 0, 1) === "0") {
        $phone = "254" . substr($phone, 1);
    }

    $source = $this->senderId ?: "MOBI_SMS";
    $apiUrl = "https://www.mobisky.biz/api/sendsms2a.php";

    $query = http_build_query([
        "username"    => $username,
        "password"    => $password,
        "message"     => $message,
        "destination" => $phone,
        "source"      => $source
    ]);

    $url = $apiUrl . "?" . $query;

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Try to decode JSON
    $responseData = json_decode($response, true);

    // === Success/Failure Check ===
    if ($httpCode == 200 && isset($responseData['status']) && $responseData['status'] === "success") {
        return "Sent";
    }

    return "Failed";
}







    public function sendMessage22222222($phone, $message) 
    {
        // Ensure phone is in correct format
        if (substr($phone, 0, 1) === "0") {
            $phone = "254" . substr($phone, 1); // e.g., 0712xxxxxx -> 254712xxxxxx
        }

        $payload = [
            "SenderId" => $this->senderId,
            "MessageParameters" => [
                [
                    "Number" => $phone,
                    "Text"   => $message
                ]
            ],
            "ApiKey"   => $this->apiKey,
            "ClientId" => $this->clientId
        ];

        // ==== Log request before sending ====
        $logData = [
            "time"    => date("Y-m-d H:i:s"),
            "request" => $payload
        ];
        file_put_contents(
            __DIR__ . "/sms_log.txt",
            json_encode($logData, JSON_PRETTY_PRINT) . PHP_EOL,
            FILE_APPEND
        );

        $ch = curl_init($this->url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // ==== Log response ====
        $logData = [
            "time"     => date("Y-m-d H:i:s"),
            "response" => $response,
            "httpCode" => $httpCode
        ];
        file_put_contents(
            __DIR__ . "/sms_log.txt",
            json_encode($logData, JSON_PRETTY_PRINT) . PHP_EOL,
            FILE_APPEND
        );

        if ($httpCode == 200 && stripos($response, "Success") !== false) {
            return "Sent";
        }

        return "Failed";
    }
}
