export default {
    data() {
      return {
        
        fields: {},
        errors: {},
        loaded: true,
        action: '', 
        text: '',
        redirect: ''
      }
    },  
    methods: {  
      //method for deleting admin user used in the views/adminuser.index blade
      deleteItem: function deleteItem(path,id){
       
        var adminpath='/bmp/admin/deleteAdmin/';
        var userpath='/bmp/users/deleteUser/';
        var grouppath='/bmp/groups/delete/';
        var clientpath='/bmp/clients/destroy/';
        var businessbillpath='/bmp/businessbill/destroy/';
        var clientgrppath='/bmp/clientsgroups/destroy/';
        var batchdeletepath = '/bmp/user/destroy/';
        var deletepaypath = '/bmp/user/destroypayment/';
        var fpath='';
        var item='';
        if(path=="admindeletepath")
        {
          fpath=adminpath;
          item="Admin User";
        }
        else if(path=="businessbilldeletepath"){
          fpath=businessbillpath;
          item="Client";
        }
        else if(path=="userdeletepath")
        {
          fpath=userpath;
          item="Customer User";
        }
        else if(path=="deletegrouppath")
        {
          fpath=grouppath;
          item="Group";
         
        }
        else if(path=="clientgrppath")
        {
          fpath=clientgrppath;
          item="Client Group";
         
        }
        else if(path == 'batchdeletepath')
        {
          fpath=batchdeletepath;
          item="Batch Payee"
        }
        else if(path == 'deletepaypath')
        {
          fpath=deletepaypath;
          item="Client Payment"
        }
        else if(path == 'customerclientdeletepath')
        {
          fpath=clientpath;
          item="Contact"
        }
       swal({
              title:'Sure to delete?',id,
              text: 'Delete '+item,
              icon: 'warning',
              type: 'warning',
              buttons:{
                confirm: {
                  text : 'Sure',
                  className : 'btn btn-success'
                },
                cancel: {
                  visible: true,
                  className: 'btn btn-info'
                }
              }
            }).then((Delete) => {
              if (Delete) {
                console.log("before: " , fpath +id);
            axios.get(fpath +id).then(function (response) {
                //this.loaded = true;
                console.log("while:" , fpath +id);
                console.log(response);
                swal({
                  title: 'Deleted!',
                  text: item+' has been deleted.',
                  type: 'success',
                  buttons : {
                    confirm: {
                      className : 'btn btn-success'                 
                    }
                  }             
                }).then(function(){
                  window.location.href = '';
                });
              
            })["catch"](function (error) {
                this.loaded = false;
            });
          } else {
                swal.close();
            }
        });
      },
      //method for rejecting user used in the views/adminuser.index blade
      rejectItem: function rejectItem(path,id){
        var payrejectpath = '/bmp/user/rejectpayment/';
        var fpath='';
        var item='';
        if(path=="payreject")
        {
          fpath=payrejectpath;
          item="Initiated Payment";
        }
        
        swal({
              title:'Sure to reject?',id,
              text: 'Reject '+item,
              icon: 'warning',
              type: 'warning',
              buttons:{
                confirm: {
                  text : 'Sure',
                  className : 'btn btn-warning'
                },
                cancel: {
                  visible: true,
                  className: 'btn btn-info'
                }
              }
            }).then((Delete) => {
              if (Delete) {
                 
                axios.get(fpath +id).then(function (response) {
                //this.loaded = true;
                swal({
                  title: 'Rejected!',
                  text: item+' has been rejected.',
                  type: 'success',
                  buttons : {
                    confirm: {
                      className : 'btn btn-success'                 
                    }
                  }             
                }).then(function(){
                    window.location.href = '';
                });
              
            })["catch"](function (error) {
                this.loaded = false;
            });
          } else {
                swal.close();
             
            }
        });
      },
      //method to retry failed
      retryItem: function retryItem(path,id){
        var payretrypath = '/bmp/user/retrypayment/';
        var fpath='';
        var item='';
        if(path=="payretry")
        {
          fpath=payretrypath;
          item="Payment";
        }
        
        swal({
              title:'Sure to retry?',id,
              text: 'Retry '+item,
              icon: 'warning',
              type: 'warning',
              buttons:{
                confirm: {
                  text : 'Sure',
                  className : 'btn btn-warning'
                },
                cancel: {
                  visible: true,
                  className: 'btn btn-info'
                }
              }
            }).then((Delete) => {
              if (Delete) {
                 
                axios.get(fpath +id).then(function (response) {
                //this.loaded = true;
                swal({
                  title: 'Rejected!',
                  text: item+' has been returned to initiations',
                  type: 'success',
                  buttons : {
                    confirm: {
                      className : 'btn btn-success'                 
                    }
                  }             
                }).then(function(){
                    window.location.href = '';
                });
              
            })["catch"](function (error) {
                this.loaded = false;
            });
          } else {
                swal.close();
             
            }
        });
      }
    }
}