<?php

namespace App\Http\Controllers\BMControllers;

use Illuminate\Http\Request;
use App\Models\bmmodels\CustomerClientGroup;
use App\Models\bmmodels\CustomerClient;
use App\Models\bmmodels\CustomerGroup;
use Auth;
use Hash;
use App\Models\bmmodels\AuditLog;
use Exception;
use ErrorException;

class ClientGroupController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('auth:admin');
    // }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // 
        try
        {
            if(Auth::user()->user_type == 'organization')
            {
                $id = Auth::user()->bulk_cust_id;
            }
            else if(Auth::user()->user_type == 'organization_user')
            {
                $id = Auth::user()->customer_cust_id;
            }
            $clients = CustomerClient::where('customer_cust_id',$id)->get();
            $groups = CustomerGroup::where('customer_cust_id',$id)->get();
            $groupid = CustomerGroup::where('customer_cust_id',$id)->pluck('cust_group_id');
            
            $groupings = CustomerClientGroup::whereIn('customer_group_cust_group_id',$groupid)->get();
            
            return view('bmviews.client-groups.index',compact('groupings','clients','groups'));
        }
        catch(ErrorException $e)
        {
            abort(401, $e->getMessage());   
            return redirect('/login')->with('failure','Access Denied. Please login to continue!');
        }
    }
    public function getClients()
    {
        if(Auth::user()->user_type == 'organization')
        {
             $id = Auth::user()->bulk_cust_id;
             $data = CustomerClient::where('customer_cust_id',$id)->get();
        
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $id = Auth::user()->customer_cust_id;
            $data = CustomerClient::where('customer_cust_id',$id)->get();
        
        }
        else {
             
             $data = CustomerClient::all();
             
        }
       
        return $data;
    }
    public function getGroups()
    {
     if(Auth::user()->user_type == 'organization')
        {
             $id = Auth::user()->bulk_cust_id;
             $data = CustomerGroup::where('customer_cust_id',$id)->get();
        
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $id = Auth::user()->customer_cust_id;
            $data = CustomerGroup::where('customer_cust_id',$id)->get();
        
        }
        else {
             
             $data = CustomerGroup::all();
             
        }
       
        return $data;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('bmviews.client-groups.create');
    }


 //vue addclient
 public function addclientgroup(Request $request)
 {
   //
   request()->validate([
    'client'=> 'required',
    'group' => 'required',     
   ]);
   
   $client_arr = [];
   foreach($request->client as $client)
   {
       //check for duplicates
       $check = CustomerClientGroup::where('customer_group_cust_group_id',$request->group['cust_group_id'])->where('customer_client_cust_client_id',$client['cust_client_id'])->with('ClientGroupClient')->get();
       if(!$check->count())
       {
         $grouping = new CustomerClientGroup();
         $grouping->customer_group_cust_group_id = $request->group['cust_group_id'];
         $grouping->customer_client_cust_client_id = $client['cust_client_id'];
         // log data
         $groupingLog = new AuditLog();
         if(Auth::user()->user_type == 'organization_user'){
               $groupingLog->audit_module = "User";
               $groupingLog->audit_activity = "Client# " .$grouping->customer_client_cust_client_id. "added to group# ".$grouping->customer_group_cust_group_id. " user added by user ID# " . Auth::user()->cust_user_id;
               $groupingLog->user_category = "User";
               $groupingLog->user_id = Auth::user()->cust_user_id;
               $grouping->created_by = Auth::user()->cust_user_username;
           }
           else{
           $groupingLog->audit_module = "Admin";
           $groupingLog->audit_activity = "Client# " .$grouping->customer_client_cust_client_id. "added to group# ".$grouping->customer_group_cust_group_id. " user added by Admin ID# ";
           $groupingLog->user_category = "Admin";
           $groupingLog->user_id = Auth::guard('admin')->user()->admin_id;
           $grouping->created_by = "ADMIN: ".Auth::guard('admin')->user()->admin_username;
           }
            
           array_push($client_arr,$grouping);
        //   return $grouping;
         // dd($customer .$customerLog);
         $grouping->save();
         $groupingLog->save();
         //write to csv
        $module="User";$activity=$groupingLog->audit_activity;$user_category='user';$user_id=$groupingLog->user_id;$datetime=date('Y-m-d h:i:s');
        $list = array (
        array($module, $activity,  $user_category,$user_id, $datetime),
        );
        
        $file = fopen("csvs/Audit.csv","a+");
        
        foreach ($list as $line) {
        fputcsv($file, $line);
        }
        
        fclose($file);
        // end write to csv
       }
       else
       {
           $check_arr= [];
           foreach($check as $check){
               array_push($check_arr,$check->ClientGroupClient->cust_client_fullname);
           }
           return response()->json(["errors"=>["client"=>["Client already exists: ".json_encode($check_arr)]]],422);
       }
    }
   return response()->json($client_arr);
   
 }



    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        return view('bmviews.client-groups.details');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        return view('bmviews.client-groups.edit');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        request()->validate([
            'client'=> 'required',
            'group' => 'required',
      
        ]);
        $id = $request->client_grp_id;
        $CustomerClientGroups = CustomerClientGroup::where('client_grp_id',$id)->get();
        //update
        $CustomerClientGroup = CustomerClientGroup::find($id);
        $CustomerClientGroup->customer_group_cust_group_id = $request->group['cust_group_id'];
        $CustomerClientGroup->customer_client_cust_client_id = $request->client['cust_client_id'];
       
        // log data
        $CustomerClientGroupLog = new AuditLog();
        
        if(Auth::user()->user_type == 'organization_user'){
            $CustomerClientGroupLog->audit_module = "User";
            $CustomerClientGroupLog->audit_activity = "Client updated from".$CustomerClientGroups." to".$CustomerClientGroup."by UserID ".Auth::user()->cust_user_id;
            $CustomerClientGroupLog->user_category = "User";
            $CustomerClientGroupLog->user_id = Auth::user()->cust_user_id;
        }
       
        
        //dd($customer .$customerLog);CustomerClient
        $CustomerClientGroupLog->save();
        $CustomerClientGroup->save(); 
        //write to csv
        $module=$CustomerClientGroupLog->audit_module;$activity=$CustomerClientGroupLog->audit_activity;$user_category=$CustomerClientGroupLog->user_category;$user_id=$CustomerClientGroupLog->user_id;$datetime=date('Y-m-d h:i:s');
        $list = array (
        array($module, $activity,  $user_category,$user_id, $datetime),
        );
        
        $file = fopen("csvs/Audit.csv","a+");
        
        foreach ($list as $line) {
        fputcsv($file, $line);
        }
        
        fclose($file);
        // end write to csv
        return $request->client;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    
{
    // try
    // {
    //find Client group  details to delete
    $CustomerClientGroup = CustomerClientGroup::where('client_grp_id',$id)->get();
    //set delete
    $deleteCustomerClientGroup= CustomerClientGroup::find($id);
    //set logging
    $adminLog = new AuditLog();
    
    if(Auth::user()->user_type == 'organization_user'){
        $adminLog->audit_module = "User";
        $adminLog->audit_activity = "Group of details: ".$deleteCustomerClientGroup. "  deleted by user ID# " .Auth::user()->cust_user_id;
        $adminLog->user_category = "User";
        $adminLog->user_id = Auth::user()->cust_user_id;
    }
    else
    {
        $adminLog->audit_module = "Admin";
        $adminLog->audit_activity = "Group of details: ".$deleteCustomerClientGroup. " deleted by Admin ID# " .Auth::guard('admin')->user()->admin_id;
        $adminLog->user_category = "Admin";
        $adminLog->user_id = Auth::guard('admin')->user()->admin_id;
    }
    //dd($deleteAdmin);
    //initiate log
    $adminLog->save();
    //write to csv
    $module=$adminLog->audit_module;$activity=$adminLog->audit_activity;$user_category=$adminLog->user_category;$user_id=$adminLog->user_id;$datetime=date('Y-m-d h:i:s');
    $list = array (
    array($module, $activity,  $user_category,$user_id, $datetime),
    );
    
    $file = fopen("csvs/Audit.csv","a+");
    
    foreach ($list as $line) {
    fputcsv($file, $line);
    }
    
    fclose($file);
    // end write to csv
    //initiate delete
    $deleteCustomerClientGroup->delete();
    // //return message
    // return redirect()->back()
    //     ->with('success','Custtomer client Group Deleted Succesfully.');
    // }
    //     catch (Exception $exception)
    // {
    //     return back()->withInput()
    //         ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
    // }
    return response()->json($CustomerClientGroup);
}
}



