<?php
if(Auth::check())
{
    $layout = 'fcviews.mobisurvey.layouts.org';
}

?>

<?php $__env->startSection('content'); ?>

<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Participants for survey <small><?php echo e($survey['name']); ?></small></h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">Participants</a>
                                    </li>
                                </ul>
                        </div></div>
                      
                        <div class="ml-md-auto py-2 py-md-0">
                            
                            <div class="btn-group dropdown">
                                <button class="btn btn-white btn-round dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="true">
                                    <i class="fas fa-plus"></i> Actions
                                </button>
                                <ul class="dropdown-menu" role="menu" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -117px, 0px); top: 0px; left: 0px; will-change: transform;">
                                    <li>
                                        <a href="#" data-target="#add" data-toggle="modal" class="dropdown-item"><i class="fa fa-plus"></i> Structure Participant</a>
                                        <a href="#" data-target="#create" data-toggle="modal" class="dropdown-item"><i class="fa fa-plus"></i> Create Participant</a>
                                        <a href="#" data-target="#import" data-toggle="modal" class="dropdown-item"><i class="fa fa-plus"></i> Import Participants</a>
                                    </li>
                                </ul>
                            </div>
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Participant Requirements</div>
                                        <!-- check if exist -->
                                            <?php if($errors->any()): ?>
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                                <strong>Error! </strong>There were some errors with inputs.
                                                <ul>
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                                </div>
                                            <?php endif; ?>
                                        <?php echo $__env->make('layouts.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php if(empty($participants)): ?>
                                        <?php echo $__env->make('layouts.nodata', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php else: ?>
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                            <?php $__currentLoopData = $tablecolumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tablecolumn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th><?php echo e(ucfirst($tablecolumn)); ?></th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                            <tr>
                                            <?php $__currentLoopData = $tablecolumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tablecolumn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <th><?php echo e(ucfirst($tablecolumn)); ?></th>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tr>
                                            </tfoot>
                                            <tbody>
                                            <?php $__currentLoopData = $participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                            <?php $__currentLoopData = $tablecolumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tablecolumn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <td><?php echo e($participant->$tablecolumn); ?></td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <td>
                                                    <button class="btn btn-sm btn-info" data-target="#edit-<?php echo e($participant->id); ?>" data-toggle="modal" id="show-modal">Edit</button>
                                                    <button class="btn btn-sm btn-danger" @click.prevent="deleteItem('deletepart','<?php echo e($participant->id); ?>')" type="">Delete</button>
                                                </td>
                                            </tr>
                                            <!-- edit participant modal -->
                                            <div class="modal fade" id="edit-<?php echo e($participant->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="exampleModalLongTitle">Edit Participant </h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body panel-default bg-light">
                                                                <form action="<?php echo e(route('mobisurvey.participants.update')); ?>" method="post">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" name="id" value="<?php echo e($participant->id); ?>" class="form-control">
                                                                <input type="hidden" name="survey" value="<?php echo e($participant->survey_id); ?>" class="form-control">
                                                                <?php $__currentLoopData = $tablecolumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tablecolumn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="col-md-12 form-group">
                                                                    <label><?php echo e(ucfirst($tablecolumn)); ?></label>
                                                                    <input type="text" required name="<?php echo e($tablecolumn); ?>" value="<?php echo e($participant->$tablecolumn); ?>" class="form-control"/>
                                                                </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <input type="hidden" name="part_id" value="<?php echo e($participant->id); ?>"/>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit" class="btn btn-success pull-right">Save</button>
                                                            </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            <!-- end edit participant modal -->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                         
                                        <?php endif; ?>
                                    </div>
                                    <!-- Create modal -->
                                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Requirements </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <create-table :survey="<?php echo e(json_encode($survey['id'])); ?>"></create-table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <!-- end Create modal -->
                                <!-- add participant modal -->
                                <div class="modal fade" id="create" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">Create Participant </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body panel-default bg-light">
                                                    <form action="<?php echo e(route('mobisurvey.participants.store')); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" required name="survey" value="<?php echo e($survey['id']); ?>" class="form-control">
                                                    <?php $__currentLoopData = $tablecolumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tablecolumn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col form-group">
                                                        <label for="import-file"><?php echo e(ucfirst($tablecolumn)); ?></label>
                                                        <input type="text" required name="<?php echo e($tablecolumn); ?>" class="form-control">
                                                    </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="modal-footer">
                                                        <input type="submit" class="btn btn-success pull-right">
                                                    </div>
                                                    </form>
                                                    
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                <!-- end add participant modal -->
                                
                                <!-- import modal -->
                                <div class="modal fade" id="import" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                            <h4>Import participants</h4>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            
                                                <div class="modal-body bg-light">
                                                <form action="<?php echo e(route('mobisurvey.participants.import')); ?>" method="post" enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" required name="survey" value="<?php echo e($survey['id']); ?>" class="form-control">     
                                                    <div class="alert alert-info shadow-sm">
                                                        <p class="mb-0">Download <a href="<?php echo e(url('/sample/'.$dbtable.'.csv')); ?>"> sample file</a></p>
                                                    </div>
                                                    <div class="col form-group">
                                                        <label for="import-file">Select excel file to import*</label>
                                                        <input name="file" id="import-file" type="file" class="form-control">
                                                    </div>
                                                    <div class="col form-group">
                                                        <button type="submit" class="btn btn-success btn-round"><i class="fa fa-check"></i> Save</button>
                                                        <button type="button" class="btn btn-danger btn-round btn-md" data-dismiss="modal">Close</button>
                                                    </div>
                                                </form>
                                                </div>
                                                
                                        </div>
                                    </div>
                                </div>
                                <!-- end import modal -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <script src='https://code.jquery.com/jquery-3.2.0.min.js'></script>
    <script src='https://unpkg.com/popper.js@1.11.1'></script>
    <script src='https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0-beta/js/bootstrap.min.js'></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dashmobisky/public_html/Accounts/resources/views/fcviews/mobisurvey/participants/index.blade.php ENDPATH**/ ?>