@extends('warrantviews.layouts.user')
@section('content')
<div id="vue-admin-user">
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Dashboard</h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="#">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                </ul>
                        </div>
                        </div>
                        
                    </div>
                </div>
            <div class="page-category">
                <div class="page-inner mt--5">
                <div class="row mt--2">
				<div class="col-md-4">
					<div class="card full-height">
						<div class="card-body">
							<div class="card-title">Account Statistics</div>
							<div class="card-category">Account Current Status</div>
							<div class="d-flex flex-wrap justify-content-around pb-2 pt-4">
								<ol>
									<li>Groups: <strong>{{count($groups)}}</strong></li>
									<li>Contacts: <strong>{{count($contacts)}}</strong></li>
									{{-- <li>Credit Received (Ksh): <strong>{{$topups}}</strong></li>
									<li>Total Credit Sent (Ksh): <strong>{{$expenditure}}</strong></li>
									<li>Credit Balance (Ksh): <strong>{{$balance[0]}}</strong></li>
								--}}</ol>
							</div>
						</div>
					</div>
				</div>
				
			 
				<div class="col-md-4">
					<div class="card">
						<div class="card-header">
							<div class="card-head-row">
								<div class="card-title"> Warranty Check</div>
							</div>
						</div>
						<div class="card-body">
						<table class="table table-hover">
							<thead>
								<tr>
								<th><a href="{{ route('mobisurvey.sumsung') }}">All</a></th>
								<th><a href="{{ route('mobisurvey.validimes') }}">Valid</a></th>
								<th><a href="{{ route('mobisurvey.invalidimes') }}">InValid</a></th>
								</tr>
							</thead>
							<tbody>
							
								<tr>
								<td> <a href="{{ route('mobisurvey.sumsung') }}"> <h1> <span class="badge badge-primary">{{ $recent_warrant_checks_all }} </span></h1></a></td>
									<td> <a href="{{ route('mobisurvey.validimes') }}"> <h1> <span class="badge badge-success">{{ $recent_warrant_checks }} </span></h1></a></td>
									<td><a href="{{ route('mobisurvey.invalidimes') }}"><h1><span class="badge badge-danger">{{ $recent_warrant_checks_invalid }}</span></h1> </a></td>
								</tr>
							
								
															
							</tbody>
							</table>
						</div>
					</div>
				</div>

				<div class="col-md-4">
					<div class="card">
						<div class="card-header">
							<div class="card-head-row">
								<div class="card-title">Recent Account Topups</div>
							</div>
						</div>
						<div class="card-body">
						<table class="table table-hover">
							<thead>
								<tr>
									<th>Date</th>
									<th>Amount</th>
								</tr>
							</thead>
							<tbody>
							@foreach($topups_recent as $topup)
								<tr>
									<td>{{$topup->topup_time}} </td>
									<td>Ksh.<b>{{$topup->credit_amount}}</b> </td>
								</tr>
							   @endforeach
							</tbody>
							</table>
						</div>
					</div>
				</div>
				


				<div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-body">Warranty Checks statistics
                                      @include ('warrantviews.partials.filter-warrantysummary')

                                            <div class="text-right mb-3 border-bottom pb-1">
                                                <div class="card-title pull-left"></div>

                                                <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-sentsms">
                                                    <i class="fas fa-filter"></i> Filter
                                                </a>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="card-category">Total number of Warranty Checks</div>
                               
                                            </div>
                                            <div class="col-md-12">
                                                <div class="card-category"></div>

                                            
                                                <div class="row py-6">
                                                    <div class="col-md-4 d-flex flex-column justify-content-around">
                                                        <div>
                                                     
                                                            <h6 class="fw-bold">Total Checks No. {{ $warrantycountall }}</h6>
                                                     
                                                            <h6 class="fw-bold"> Valid Checks No. {{ $warrantycountSuccess }}</h6>
                                             
                                                            <h6 class="fw-bold"> Invalid Checks No. {{ $warrantycountfailed }}</h6>
														
                                                        </div>
                                                    </div>
                                                    <div class="col-md-8">
                                                        <div style="width:100%;">

                                                            <div id="chart">
                                                            {!! $chart1->container() !!}
                                                            </div>
                                              
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>	
                        </div>




			</div>
		</div>
            </div>
        </div>
    </div>
</div>
    @endsection