@php
if(Auth::user()->user_type == 'organization')
{
    $layout = 'fcviews.layouts.org';
}
elseif(Auth::user()->user_type == 'organization_user')
{
    $layout = 'fcviews.layouts.user';
}
@endphp
@extends($layout)
@section('content')
<div class="main-panel">
    <div class="content">
            <div class="panel-header">
                <div class="page-inner py-5 text-white"  style="background:#313232">
                    <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
                        <div><div class="page-header">
                            <h4 class="page-title text-white">Messages </h4>
                            <ul class="breadcrumbs">
                                    <li class="nav-home">
                                        <a class="text-white" href="">
                                            <i class="flaticon-home"></i>
                                        </a>
                                    </li>
                                    <li class="separator">
                                        <i class="flaticon-right-arrow"></i>
                                    </li>
                                    <li class="nav-item">
                                        <a class="text-white" href="">UnTagged/Other </a>
                                    </li>
                                </ul>
                        </div></div>
                        <div class="ml-md-auto py-2 py-md-0">
                            <a href="" class="btn btn-white btn-border btn-round mr-2"><i class="fas fa-arrow-circle-left"></i> Back</a>
                            <!-- <a href="#" data-target="#add" data-toggle="modal" id="show-modal" class="btn btn-white btn-round"><i class="fa fa-plus"></i> Add Inbox Tags </a> -->
                        </div>
                    </div>
                </div>
            <div id="app">
            <div class="page-category">
                <div class="page-inner mt--5">
                    <div class="row mt--2">
                            <div class="col-md-12">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <div class="card-title">Untagged Messages </div>
                                        <!-- check if exist -->
                                        @if(!$messages->count())
                                        @include('layouts.nodata')
                                        @else
                                        
                                        <div class="table-responsive">
                                        <table  id="table" class="display table table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th>ID#</th>
                                                <th>From</th>
                                                <th>Message</th>
                                                <th>Time</th>
                                            
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                <th>ID#</th>
                                                <th>From</th>
                                                <th>Message</th>
                                                <th>Time</th>
                                            
                                                <th class="text-center">Action</th>
                                                </tr>
                                            </tfoot>
                                            <tbody>
                                            @foreach($messages as $message)
                                            <tr>
                                            <td>{{ $message->id }}</td>
                                            <td>{{ $message->sender }}</td>
                                            <td>{{ $message->sms }}</td>
                                            <td>{{ $message->date_time_received }}</td>
                                            <td>
                                            <div class="form-button-action" role="group" aria-label="Actions">
                                            <a href="#" data-target="#respond" data-toggle="modal" id="show-modal"> <button class="btn btn-info btn-sm" data-toggle="tooltip"  data-original-title="Respond"><i class="far fa-feedback"></i>  Respond</button></a>
                                            
                                            </form>
                                            </div>
                                            </td>
                                            </tr>
                                            <!-- respond modal -->
                                            <div class="modal fade" id="respond" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLongTitle">Respond to Message </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body panel-default bg-light">
                                                            <respond_component :messagedata="{{ json_encode($message)}}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end respond modal -->
                                            @endforeach
                                            </tbody>
                                        </table>
                                         
                                        @endif
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
            </div>
            </div>
            </div>
        </div>
    </div>
    @endsection