<?php

namespace App\Models\fcmodels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Organization extends Authenticatable
{
    use Notifiable;

    //use online available db
    /* protected $primaryKey='management_accounts_id';
     protected $table = 'management_accounts'; */
     protected $connection = 'mysql_newfc';
   
    //
    protected $table = 'organizations';
    protected $primaryKey = 'organization_id';
    
    protected  $fillable = [
        'organization_id',
        'name',
        'api_account',
        'email',
        'username',
        'short_code',
        'password',
        'status',
    ];
    // RELATIONSHIPS
    // organization---organization users rlshp
    public function orgUsers()
    {
        return $this->hasMany(OrganizationUser::class,'organization_id');
    }
    // organization---contacts rlshp
    public function orgContacts()
    {
        return $this->hasMany(Contact::class,'organization_id');
    }
    // organization---group rlshp
    public function orgGroups()
    {
        return $this->hasMany(Group::class,'organization_id');
    }
    // organization---department rlshp
    public function orgDepts()
    {
        return $this->hasMany(Department::class,'organization_id');
    }
    // organization---incomingsms rlshp
    public function orgIncoming()
    {
        return $this->hasMany(IncomingSms::class,'organization_id');
    }

    public function orgImport()
    {
        return $this->hasMany(Import::class,'organization_id');
    }
    //ivr request
    public function orgIvr()
    {
        return $this->hasOne(IvrRequest::class,'organization_id');
    }
    //survey request
    public function orgSurvey()
    {
        return $this->hasOne(SurveyRequest::class,'organization_id');
    }
    //survey request
    public function organizationSurvey()
    {
        return $this->hasMany(Survey::class,'organization_id');
    }
    //org ><ivr
    public function orgIvrs()
    {
        return $this->hasMany(Ivr::class,'organization_id');
    }
    // organization---bulksms rlshp
    // public function orgBulk()
    // {
    //     return $this->hasMany(BulkSms::class,'organization_id');
    // }
}
