<?php

namespace app\Imports\FCImports;

use App\Models\fcmodels\Contact;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
//batch inserts do not rollback all but the batch that failed 
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithValidation;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
class ClientsImport implements ToCollection, WithHeadingRow, WithBatchInserts, WithChunkReading, WithValidation
{
    use Importable;
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    //get cust id
    protected $id;

    public function __construct($id) {
        $this->id = $id;
    }
    //insert to db
 public function collection(Collection $row)
{
    try {
        $foos = $row->toArray();

        foreach ($foos as $foo) {
            $no = str_replace(' ', '', $foo['phone']);
            $number = "";

            if ((substr($no, 0, 4) == "+254") || (substr($no, 0, 3) == "254") || (substr($no, 0, 2) == "07") || (substr($no, 0, 1) == "7")) {
                if (substr($no, 0, 4) == "+254") {
                    $number = "254" . substr($no, 4);
                } elseif (substr($no, 0, 3) == "254") {
                    $number = "254" . substr($no, 3);  
                } elseif (substr($no, 0, 1) == "0") {
                    $number = "254" . substr($no, 1); 
                } elseif (substr($no, 0, 1) == "7") {
                    $number = "2547" . substr($no, 1); 
                }
            }

            Contact::create([
                'name' => $foo['name'] ?? null,
                'phone' => $number,
                'group_id' => $foo['group_id'] ?? null,
                'organization_id' => $this->id,
            ]);
        }

        return redirect()->back()->with('success', "Contacts Uploaded Successfully");
    } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
        $failures = $e->failures();
        // Handle or log failures
    }
}

   public function rules(): array
    {
        return [
            //for non batch
           

            // 'phone' =>'integer|max:799999999999|min:700000000|unique:contacts,phone',
          
        ];
    }
    public function customValidationMessages()
    {
        return [
       
            'phone.max' => 'Phone number must be 12 characters of format "254712345678"',
            'phone.min' => 'Phone number must be 12 characters of format "254712345678".'
    
    
    
        ];
    }
    public function batchSize(): int
    {
        return 200;
    }
    public function chunkSize(): int
    {
        return 200;
    }

}
