<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use App\Models\fcmodels\Contact;
use App\Models\fcmodels\Group;
use App\Models\fcmodels\Bulksms;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\Import;
use Auth;
use App\Models\AuditLog;

class SmsComposerController extends Controller
{ 
    public function index()
    {
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
       
        $sms = Bulksms::where('site',$name)->take(1000)->orderByDesc('bulk_sms_id')->get();
        $wallet = Wallet::where('shopid',$api_account)->pluck('amount');
        return view('fcviews.smscomposer.index',compact('sms','wallet'));
    }




    //store
    public function storeGroup(Request $request)
    {
        $request->validate([
       
            'group_name' => 'required',
    
                    
                ]);
        $data = new Group();
        $data->group_name = $request->group_name;
        $data->description = $request->description;
        $data->status = 1;
        $data->organization_id = Auth::guard('organization')->user()->organization_id;


        // return $data;
        $data->save ();
        //log
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Organization";
        $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
       
        $adminLog->user_category = "Admin";
        $adminLog->user_id = Auth::user()->organization_id;
        ;
        $adminLog->save();
        
        return response()->json($data);
    }




 //edit
 public function sendsmsinport(Request $request)

 {

  //  try
    { 
        request()->validate([
           // 'name'=> 'required',
  
        ]);
      ///  return $request;
    //current customer 
  //  $id=2;
    $fd=Auth::guard('organization')->user()->organization_id;
   // $contactsdets = Import::where('import_id',$fd);
    $data = Import::where('organization_id',$fd)->where('status','0')->pluck('import_id');
    //return $data;
    //dd($data);
    //update
    $data1 = Import::findOrFail($data);
   //return $data1;
   // $data->name = $request->get('name');
    $data1->status =1;
   // $data->group_id = $request->get('group_id');
  


    // log data
    $adminLog = new AuditLog();
    $adminLog->audit_module = "Organization";
    $adminLog->audit_activity = "Organization user ".$request->username ." added by Admin ID# " .Auth::user()->organization_id;
   
    $adminLog->user_category = "Admin";
    $adminLog->user_id = Auth::user()->organization_id;
    //dd($adminLog);
    $adminLog->save();
    //$data1->save();
    //return response()->json($data1);
    $sms = Import::where('organization_id',"2")->get();

  //  return view('exceluploads.index',compact('sms'));
      return redirect()->back()

        ->with('success','Messages Sent Succesfully.'); 
        
    }
  //  catch (Exception $exception)
   // {
      //  return back()->withInput()
        //    ->with(['failure' => 'Unexpected error occurred while trying to process your request. Please try Again.']);
  //  }
 }







}
