<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use Auth;
use Log;
use App\Models\fcmodels\Response;
use DB;
use PDF;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class PdfController extends Controller
{
    //single participant report
    public function index($id)
    {
        //
        if(Auth::user()->user_type == 'organization')
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else
        {
            return abort('401');
        }
        //get table
        $response=Response::where('participant_id',$id)->with('responseQuestion')->first();
        $survey_id = $response->responseQuestion->survey_id;
        $dbtable = 'participant_'.$ids.'_'.$survey_id;
        //get participant dets
        $checkarray=count(Schema::getColumnListing($dbtable));
        if(!empty($checkarray))
        {
           $tablecolumns1=array_slice(Schema::getColumnListing($dbtable),0,$checkarray-4);
            //get the table columns
            $tablecolumns=array_slice($tablecolumns1,2);
            $participant = DB::select("SELECT * FROM $dbtable WHERE id='$id'"); 
        }
        //get responses to this quiz
        $responses = Response::where('participant_id',$id)->with('responseQuestion')->get();
        $pdf = PDF::loadView('fcviews.pdf.participantresponsespdf',compact('id','dbtable','responses','tablecolumns','participant'));
        return $pdf->download('Participant_Responses.pdf');
    }
    //all participants report
    public function all($id)
    {
        //
        if(Auth::user()->user_type == 'organization')
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else if(Auth::user()->user_type == 'organization_user')
        {
            $ids = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $api_account = Auth::user()->api_account;
        }
        else
        {
            return abort('401');
        }
        //get table
        $dbtable='participant_'.$ids.'_'.$id;
        //get participant dets
        $checkarray=count(Schema::getColumnListing($dbtable));
        if(!empty($checkarray))
        {
           $tablecolumns1=array_slice(Schema::getColumnListing($dbtable),0,$checkarray-4);
            //get the table columns
            $tablecolumns=array_slice($tablecolumns1,2);
            $participant = DB::select("SELECT id FROM $dbtable"); 
        }
       
        $participants = DB::select("SELECT * FROM $dbtable where status = 1");
        $pdf = PDF::loadView('fcviews.pdf.allparticipantresponsespdf',compact('id','dbtable','tablecolumns','participants'));
        return $pdf->download('All_Participant_Responses.pdf');
    }
}
