<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use App\Classes\FCClasses\SendSms;
use App\Classes\FCClasses\Replysms;
use App\Classes\FCClasses\SMSCounter;
use App\Models\fcmodels\Incoming;
use App\Models\fcmodels\Import;
use App\Models\fcmodels\APIUser;
use App\Models\fcmodels\Bulksms;
use App\Models\fcmodels\Contact;
use App\Models\fcmodels\Group;
use App\Models\fcmodels\Organization;
use App\Models\fcmodels\Wallet;
use App\Models\fcmodels\CountryRate;
use App\Models\fcmodels\ManagementAccount;
use Auth;
use Log;
use Carbon\Carbon;

class BulkSmsController extends Controller
{
    //send to contact
    public function smsContact(Request $request){
        request()->validate([
            'contact' => 'required',
            'message' => 'required',
        ]);
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        //get user creds
        $api = APIUser::where('shop_id',$Id)->first();
        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $contact_arr=[];
        $contacts = $request->contact;
               ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$Id)->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {
            $message = $request->message;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$Id)->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return response()->json(['errors'=>['message'=>['Sorry! You do not have sufficient funds. Total charges are: '.$totalcost]]],422);
        }
        ///////////

        foreach($contacts as $phone)
        {

            $message = $request->message;
            $phone=$phone['phone'];
            $smsobject=new SendSms($username,$password);

            $textstatus=$smsobject->sendMessage($phone,$message);
            array_push($contact_arr,$textstatus);

        }
        return $textstatus;
    }
    ///////////////////SCHEDULE TO CONTACTS
        public function scheduleContact(Request $request){
        request()->validate([
            'contact' => 'required',
            'message' => 'required',
            'date' => 'required',
            'time' => 'required',
        ]);
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        //get user creds
        $api = APIUser::where('shop_id',$Id)->first();
        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $contact_arr=[];
        $contacts = $request->contact;
               ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$Id)->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {
            $message = $request->message;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$Id)->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return response()->json(['errors'=>['message'=>['Sorry! You do not have sufficient funds. Total charges are: '.$totalcost]]],422);
        }
        ///////////
        //get site
        $site = ManagementAccount::where('api_account',$Id)->pluck('organization');
       $date = Carbon::create($request->date ." ". $request->time);
        foreach($contacts as $phone)
        {

            $message = urlencode($request->message);
            $phone=$phone['phone'];
            //schedule
            $set = Bulksms::create([
                        'recipients' => $phone,
                        'message'=>$message,
                        'datetime' => now(),
                        'authorized' => 'Yes',
                        'authorizer' => $id,
                        'date_authorized' => now(),
                        'override' => 'Excel Upload',
                        'site' => $site[0],
                        'scheduleDateTime' => $date,
                        'scheduleSMS_status' => 'Pending',
                        'user_id'=>$id
                    ]);
            array_push($contact_arr,$set);

        }
        return $contact_arr;
    }
    /////////////////SCHEDULE TO GROUP
    public function scheduleGroup(Request $request){
        request()->validate([
            'date' => 'required',
            'time' => 'required',
            'group' => 'required',
            'message' => 'required',
        ]);
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        //get grouped contacts
        $contacts = Contact::where('group_id',$request->group[0]['group_id'])->pluck('phone');

        //get user creds
        $api = APIUser::where('shop_id',$Id)->first();
        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $contact_arr=[];
        ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$Id)->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {
            $message = $request->message;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$Id)->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return response()->json(['errors'=>['message'=>['Sorry! You do not have sufficient funds. Total charges are: '.$totalcost]]],422);
        }
        ///////////
        $site = ManagementAccount::where('api_account',$Id)->pluck('organization');
        $date = Carbon::create($request->date ." ". $request->time);
        foreach($contacts as $phone)
        {
            $message = urlencode($request->message);
            $set = Bulksms::create([
                        'recipients' => $phone,
                        'message'=>$message,
                        'datetime' => now(),
                        'authorized' => 'Yes',
                        'authorizer' => $id,
                        'date_authorized' => now(),
                        'override' => 'Excel Upload',
                        'site' => $site[0],
                        'scheduleDateTime' => $date,
                        'scheduleSMS_status' => 'Pending',
                        'user_id'=>$id
                    ]);
            array_push($contact_arr,$set);

        }
        return $contact_arr;
    }
    //send to group
    public function smsGroup(Request $request){
        request()->validate([
            'group' => 'required',
            'message' => 'required',
        ]);
        if(Auth::check())
        {
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        //get grouped contacts
        $contacts = Contact::where('group_id',$request->group[0]['group_id'])->pluck('phone');

        //get user creds
        $api = APIUser::where('shop_id',$Id)->first();
        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $contact_arr=[];
        ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$Id)->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {
            $message = $request->message;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$Id)->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return response()->json(['errors'=>['message'=>['Sorry! You do not have sufficient funds. Total charges are: '.$totalcost]]],422);
        }
        ///////////
        foreach($contacts as $phone)
        {
            $message = $request->message;
            $smsobject=new SendSms($username,$password);

            $textstatus=$smsobject->sendMessage($phone,$message);
            array_push($contact_arr,$textstatus);

        }
        return $textstatus;
    }
    //reply
    public function smsReply(Request $request){
        request()->validate([
            'contact' => 'required',
            'reply' => 'required',
        ]);
        if(Auth::check())
        {
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
         $shortcode=$request->shortcode;
        //get user creds
        $api = APIUser::where('shop_id',$Id)->first();
        //send sms
        $username = $api['username'];
        $password = $api['password'];

            $message = $request->reply;
            $smsobject=new Replysms($username,$password);

            $textstatus=$smsobject->sendMessage($request->contact,$message,$shortcode);

             if($textstatus == "Sent")
             {
                 //updatetable
                 $update = Incoming::findOrFail($request->id);
                 $update->response=$request->reply;
                 $update->responded_to='Yes';
                 $update->save();
                 return $update;
             }

    }

    //send to Import
    public function smsImport(Request $request){

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        //get Imported contacts


        $contacts = Import::where('organization_id',$id)->where('status','0')->get();
        // return $contacts;
        //get user creds
        $api = APIUser::where('shop_id',$Id)->first();

        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $contact_arr=[];

        $i=array();
        foreach($contacts as $phone)
        {
            $importid= $phone['import_id'];
            $message = $phone['message'];
            $phone = $phone['phone'];
            $smsobject=new SendSms($username,$password);
            $data1 = Import::findOrFail($importid);


           // $data1->status =1;
            $data1->delete();

            $textstatus=$smsobject->sendMessage($phone,$message);
            Log::info($textstatus);
            array_push($contact_arr,$textstatus);
            if($textstatus=="Sent"){

            array_push($i,$textstatus);
            }



        }
        if(count($contacts)==count($i)){
            return redirect()->back()->with('success',count($i).' Messages Sent Succesfully.');

        }
        else{
             return redirect()->back()->with('error','Message Failed to send.');
        }



    }




 //send to Import
    public function MessageTypesmsImport(Request $request){

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account=Organization::where('organization_id',$id)->first();
        }
        else{
            return abort('401');
        }
        //get Imported contacts


        $contacts = Import::where('organization_id',$id)->where('status','0')->get();
        // return $contacts;
        //get user creds
        $api = APIUser::where('shop_id',$api_account['api_account'])->first();

        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $message6 =  $request->comment;
        // return $message6;
       ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$api_account['api_account'])->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {
            $importid= $phone['import_id'];
            $message = $message6;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$api_account['api_account'])->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return back()->with('failure','Sorry! You do not have sufficient funds. Total charges are: '.$totalcost,422);
        }
        ///////////

        $contact_arr=[];

        $i=array();
        foreach($contacts as $phone)
        {
            $importid= $phone['import_id'];
            $message = $message6;
            $phone = $phone['phone'];
            $smsobject=new SendSms($username,$password);

            $textstatus=$smsobject->sendMessage($phone,$message);
             array_push($contact_arr,$textstatus);
            if($textstatus=="Sent"){

            array_push($i,$textstatus);
            }

            //delete the data(contact)
            $data1 = Import::findOrFail($importid);
            $data1->delete();



        }
        if(count($contacts)==count($i)){
            return redirect()->back()->with('success',count($i).' Messages Sent Succesfully.');

        }
        else{
             return redirect()->back()->with('error','Message Failed to send.');
        }



    }

    //send message with value from excel
    public function sendMessageExcel(Request $request){

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account=Organization::where('organization_id',$id)->first();
        }
        else{
            return abort('401');
        }
        //get Imported contacts


        $contacts = Import::where('organization_id',$id)->where('status','0')->get();
        // return $contacts;
        //get user creds
        $api = APIUser::where('shop_id',$api_account['api_account'])->first();

        //send sms
        $username = $api['username'];
        $password = $api['password'];


        $contact_arr=[];

        $contacts= json_decode($request->contactsv);
       // return $contacts[0];
        $contact_arr=[];
               ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$api_account['api_account'])->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {
            $message = $phone->message;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$api_account['api_account'])->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return back()->with('failure','Sorry! You do not have sufficient funds. Total charges are: '.$totalcost,422);
        }
        ///////////
        $i=array();

        foreach($contacts as $phone)
        {

            $importid= $phone->import_id;
            $message = $phone->message;
            $phone = $phone->phone;
            $smsobject=new SendSms($username,$password);

            $textstatus=$smsobject->sendMessage($phone,$message);
             array_push($contact_arr,$textstatus);
            if($textstatus=="Sent"){

            array_push($i,$textstatus);
            }

            //delete the data(contact)
            $data1 = Import::findOrFail($importid);
            $data1->delete();



        }
        if(count($contacts)==count($i)){
            return redirect()->back()->with('success',count($i).' Messages Sent Succesfully.');

        }
        else{
             return redirect()->back()->with('error','Message Failed to send.');
        }

    }





     //send From Template
    public function TemplatesmsImport(Request $request){
   $import_name=$request->import_name;
   $phoneno =  $request->contact;
  // dd($import_name);

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account=Organization::where('organization_id',$id)->first();
        }
        else{
            return abort('401');
        }
        //get Imported contacts


        $contacts = Import::where('organization_id',$id)->where('status','0')->get();
        // return $contacts;
        //get user creds
        $api = APIUser::where('shop_id',$api_account['api_account'])->first();

        $message=$request->comment;



   //$fn=  print_r(str_replace('{LAST_NAME}',$LAST_NAME,$sd));

 //dd($sd);
        //send sms
        $username = $api['username'];
        $password = $api['password'];
         //$message6 =  $request->comment;
       // $message6 =  $sd;

       ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$api_account['api_account'])->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {

            $LAST_NAME=$phone['import_name'];
          //$FIRST_NAME=' ';
            $message6=str_replace('{LAST_NAME}',$LAST_NAME,$message);
            $importid= $phone['import_id'];
            $message = $message6;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$api_account['api_account'])->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return back()->with('failure','Sorry! You do not have sufficient funds. Total charges are: '.$totalcost,422);
        }
        ///////////

        $contact_arr=[];

        $i=array();
        foreach($contacts as $phone)
        {
            $LAST_NAME=$phone['import_name'];
            //$FIRST_NAME=' ';
            $message6=str_replace('{LAST_NAME}',$LAST_NAME,$request->comment);
            $importid= $phone['import_id'];
            $message = $message6;
            $phone = $phone['phone'];

            $smsobject=new SendSms($username,$password);

            $textstatus=$smsobject->sendMessage($phone,$message);
             array_push($contact_arr,$message6);


            if($textstatus=="Sent"){

            array_push($i,$textstatus);
            }

            // delete the data(contact)
            $data1 = Import::findOrFail($importid);
            $data1->delete();



        }
        if(count($contacts)==count($i)){
            return redirect()->back()->with('success',count($i).' Messages Sent Succesfully.');

        }
        else{
             return redirect()->back()->with('error','Message Failed to send.');
        }



    }



 //send to Import
    public function ContactMessageTypesms(Request $request){

        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $api_account=Organization::where('organization_id',$id)->first();
        }
        else{
            return abort('401');
        }

        //get user creds
        $api = APIUser::where('shop_id',$api_account['api_account'])->first();

        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $message =  $request->comment;
        $phoneno =  $request->contact;
        $contact_arr=[];
        $contactsarray=explode(",",$phoneno);
               ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$api_account['api_account'])->pluck('amount');
       $arr = [];
       foreach($contactsarray as $phone)
        {
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$api_account['api_account'])->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return back()->with('failure','Sorry! You do not have sufficient funds. Total charges are: '.$totalcost,422);
        }
        ///////////
        $i=0;
         foreach($contactsarray as $phone){

             $smsobject=new SendSms($username,$password);

             $textstatus=$smsobject->sendMessage($phone,$message);
             if($textstatus=="Sent"){
                 $i=$i+1;
             }
             array_push($contact_arr,$textstatus);
         }

        if($textstatus=="Sent"){


            if(count($contact_arr)==(int)$i){
                    return redirect()->back()->with('success',$i.' Messages Sent Succesfully.');

            }
            else{
                     return redirect()->back()->with('error','Message Failed to send.');
                }
            }
            else{
                 return redirect()->back()->with('error','Message Failed to send.');
            }

    }

    //show the custom sms page

    public function customSMS(){
         if(Auth::check())
        {
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }


       $wallet = Wallet::where('shopid',$Id)->pluck('amount');

        return view('customsms.index',compact('wallet'));
    }














    public function smsShortcodeGroup(Request $request){
        request()->validate([
            'group' => 'required',
            'message' => 'required',
        ]);
        if(Auth::check())
        {
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        //get grouped contacts
        $contacts = Contact::where('group_id',$request->group[0]['group_id'])->pluck('phone');

        //get user creds
        $api = APIUser::where('shop_id',$Id)->first();
        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $contact_arr=[];
        ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$Id)->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {
            $message = $request->message;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$Id)->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return response()->json(['errors'=>['message'=>['Sorry! You do not have sufficient funds. Total charges are: '.$totalcost]]],422);
        }
        ///////////
        foreach($contacts as $phone)
        {
            $message = $request->message;
            $smsobject=new SendSms($username,$password);

            $textstatus=$smsobject->sendMessage($phone,$message);
            array_push($contact_arr,$textstatus);

        }
        return $textstatus;
    }



    public function smsShortcodeContact(Request $request){
        request()->validate([
            'contact' => 'required',
            'message' => 'required',
        ]);
        if(Auth::check())
        {
            $id = Auth::user()->organization_id;
            $name = Auth::user()->name;
            $Id = Auth::user()->api_account;
        }
        else{
            return abort('401');
        }
        //get user creds
        $api = APIUser::where('shop_id',$Id)->first();
        //send sms
        $username = $api['username'];
        $password = $api['password'];
        $contact_arr=[];
        $contacts = $request->contact;
               ///////check balance and sum texts costs////
       $wallet = Wallet::where('shopid',$Id)->pluck('amount');
       $arr = [];
       foreach($contacts as $phone)
        {
            $message = $request->message;
            $smscountclass = new SMSCounter();
            $smscount = $smscountclass->count($message)->messages;
            array_push($arr,$smscount);
        }
        $allmessages = array_sum($arr);
        $rates = CountryRate::where('current',1)->where('shopid',$Id)->pluck('rate');

        $totalcost = $rates[0]*$allmessages;

        if($totalcost>$wallet[0]){
            return response()->json(['errors'=>['message'=>['Sorry! You do not have sufficient funds. Total charges are: '.$totalcost]]],422);
        }
        ///////////

        foreach($contacts as $phone)
        {

            $message = $request->message;
            $phone=$phone['phone'];
            $smsobject=new SendSms($username,$password);

            $textstatus=$smsobject->sendMessage($phone,$message);
            array_push($contact_arr,$textstatus);

        }
        return $textstatus;
    }
}

