<?php

namespace App\Http\Controllers\FCControllers;

use Illuminate\Http\Request;
use App\Models\fcmodels\AdminUser;
use App\Models\fcmodels\AuditLog;
use App\Models\User;
use Exception;
use Auth;
use Hash;

class AdminUserController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('auth:admin');
    // }
    /**
     * Display a listing of the resource..
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try      
        {
        $admins = AdminUser::all();
        return view('fcviews.admin-user.index', compact('admins'));
        }
        catch(Exception $e)
        {
            abort(500, $e->getMessage());   
        }
    }

    //store
    public function storeAdmin(Request $request)
    {
        $request->validate([
            'username' => 'required|string|unique:'.AdminUser::class.',admin_username',
            'email' => 'required|email|unique:'.AdminUser::class.',email',
            'othername' => 'required|string',
            'surname' => 'required|string',
            'password_confirmation' => 'required|string|min:10',
            'password' => ['required','confirmed',
                        'string',
                        'min:10',             // must be at least 10 characters in length
                        'regex:/[a-z]/',      // must contain at least one lowercase letter
                        'regex:/[A-Z]/',      // must contain at least one uppercase letter
                        'regex:/[0-9]/',      // must contain at least one digit
                        'regex:/[@$!%*#?&]/', // must contain a special character]
                        ],
                    ],
                   [
                    'surname.required' => 'Please enter surname',
                    'othername.required' => 'Please enter othername(s)',
                    'username.required' => 'Please enter username',
                    'email.required' => 'Please enter email',
                    'email.unique' => 'Email has already been taken, try another one',
                    'password.required' => 'Please enter password',
                    'password.min' => 'Password must be atleast 10 characters',
                    'password.regex' => 'Password must contain at least one lowercase, one uppercase letter, one digit, and a special character[@$!%*#?&]',
                    'password_confirmation.required' => "Please confirm password",
                    'password_confirmation.min' => "Password must be atleast 10 characters",
                    'password.confirmed' => "Passwords do not match",
                    
                ]);
        $data = new AdminUser();
        $data->admin_surname = $request->surname;
        $data->admin_othername = $request->othername;
        $data->admin_username = $request->username;
        $data->email = $request->email;
        $data->password = Hash::make($request->password);
        $data->admin_status = 1;
        // return $data;
        $data->save();
        //create dash user
        $newuser = new User();
        $newuser->username = $request->get('username');
        $newuser->email = $request->get('email');
        $newuser->user_type = 'admin';
        $newuser->password = Hash::make($request->password);
        $newuser->save();
        //log
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Admin";
        $adminLog->audit_activity = "Admin user ".$request->username ." added by Admin ID# " .Auth::id();
       
        $adminLog->user_category = "Admin";
        $adminLog->user_id = Auth::id();
        
        $adminLog->save();
        
        return response()->json('Success');
    }

    //edit
    public function editAdmin(Request $request)
    {
        $this->validate($request, [
            'username' => 'required|string',
            'email' => 'required|email',
            'othername' => 'required|string',
            'surname' => 'required|string',
            'password_confirmation' => 'string|min:10',
            'password' => ['confirmed',
                        'string',
                        'min:10',             // must be at least 10 characters in length
                        'regex:/[a-z]/',      // must contain at least one lowercase letter
                        'regex:/[A-Z]/',      // must contain at least one uppercase letter
                        'regex:/[0-9]/',      // must contain at least one digit
                        'regex:/[@$!%*#?&]/', // must contain a special character]
        ],
        ],
        [
            'surname.required' => 'Please enter surname',
            'othername.required' => 'Please enter othername(s)',
            'username.required' => 'Please enter username',
            'email.required' => 'Please enter email',
            'password.min' => 'Password must be atleast 10 characters',
                    'password.regex' => 'Password must contain at least one lowercase, one uppercase letter, one digit, and a special character[@$!%*#?&]',
                    'password_confirmation.required' => "Please confirm password",
                    'password_confirmation.min' => "Password must be atleast 10 characters",
                    'password.confirmed' => "Passwords do not match",
        ]
    );
        $id = $request->id;
        $admin_surname = $request->surname;
        $admin_othername = $request->othername;
        $admin_username = $request->username;
        if($request->password != '')
        {
        $password = Hash::make($request->password);
        
        $data = AdminUser::findOrFail($id);
        $data->admin_surname=$admin_surname;
        $data->admin_othername=$admin_othername;
        $data->admin_username=$admin_username;
        $data->password=$password;
        }
        else
        {
        $data = AdminUser::findOrFail($id);
        $data->admin_surname=$admin_surname;
        $data->admin_othername=$admin_othername;
        $data->admin_username=$admin_username;
        }
       $data->save();
            $updateduser=AdminUser::where('admin_id', $id)->first();
            // log data
            $adminLog = new AuditLog();
            $adminLog->audit_module = "Admin";
            $adminLog->audit_activity = "Admin user ".$admin_username ." updated to " .$admin_username. " by Admin ID#" .Auth::id();
            
            $adminLog->user_category = "Admin";
            $adminLog->user_id =Auth::id();
            $adminLog->save();
            return 'Success';
        
    }

    //delete
    public function deleteAdmin($id){
        //find user details to delete
        $admin = AdminUser::where('admin_id',$id)->get();
        //set delete
        $deleteAdmin = AdminUser::find($id);
        $deleteAdmin->delete();
        //set logging
        $adminLog = new AuditLog();
        $adminLog->audit_module = "Admin";
        $adminLog->audit_activity = "Admin of details: ".$admin." deleted by Admin ID#" .Auth::id();
        
        $adminLog->user_category = "Admin";
        $adminLog->user_id = Auth::id();
        $adminLog->save();
        
        return 'Success';
    }
}

