<?php

namespace App\Http\Controllers\BundlesControllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Hash;
use Log;
use DB;
use Carbon\Carbon;
use App\Charts\FCCharts\SMSChart;

use App\Models\atmodels\Airtime_customer;
use App\Models\atmodels\Airtime_contact; //contatcs
use App\Models\atmodels\Airtime_sending_record; //expenditure
use App\Models\atmodels\Currency_credit; //balance
use App\Models\atmodels\CreditTopup; //topups
use App\Models\atmodels\Airtime_group;
use App\Models\bundles\Data_Bundles_TopUp;
use App\Models\atmodels\User;
use App\Models\UserDash;
use App\Models\atmodels\DataBundlesCredits;
use EloquentBuilder;
use App\Charts\BundlesCharts\BundlesChart;
use App\Models\fcmodels\Currency_Expenditure;

class BundlesCustomerController extends Controller
{
    //
    
      public function dashboard()
    {
        //
        if(Auth::user()->user_type == 'organization_user' || Auth::user()->user_type == 'organization')
        {
            $shop_id=Auth::user()->shop_id;
            $customer_id=Auth::user()->userShopUser['customer_id'];
            $groups=Airtime_group::where('ShopID',$shop_id)->get();
            $topups=CreditTopup::where('shop_id',$shop_id)->sum('credit_amount');
            $balance=Currency_credit::where('shopid',$shop_id)->pluck('amount'); 
            $expenditure=Airtime_sending_record::where('customer_id',$customer_id)->sum('airtime_sent');
            $contacts = Airtime_contact::where('ShopID',$shop_id)->with('contactGroup')->get();
            $users = User::where('shop_id',$shop_id)->get();
            $search ='Dear Customer you have received';
            //recent topups
            $expenditure_recent=Currency_Expenditure::where('sms','LIKE', '%'.$search.'%')->where('shopid',$shop_id)->latest('date_time')->take(2)->get();
            //recent my account tpups
            $topups_recent=CreditTopup::where('shop_id',$shop_id)->latest('topup_time')->take(2)->get();
            
              $wallet = Currency_credit::where('shopid',$shop_id)->pluck('amount');   
              $datawallet = DataBundlesCredits::where('shopid',$shop_id)->pluck('amount');  
           
            
           
           
           
                      
             // $query =Data_Bundles_TopUp::where('shopid',$shop_id);
            //  $bundlescountall=EloquentBuilder::to($query,request()->all())->sum('qnty');
                      
              $query =Data_Bundles_TopUp::where('shopid',$shop_id)->where('unit','MB');
             // $query = Data_Bundles_TopUp::where('shopid', $shop_id)->where('unit', 'MB')->sum('qnty');
              $bundlesinMBs=EloquentBuilder::to($query,request()->all())->sum('qnty');
             // $sum = array_sum($numbers);
              $query =Data_Bundles_TopUp::where('shopid',$shop_id)->where('unit','GB');
              $bundlesinGBs=EloquentBuilder::to($query,request()->all())->sum('qnty');
          
              $bundlescountall=($bundlesinMBs/1000)+$bundlesinGBs;
                      
              $borderColors = [ "#acacac", "#f25961" ];
              $fillColors = ["#f27200","#59d05d" ];
              $chart2 = new BundlesChart;
              // $chart2->minimalist(true);
              $chart2->labels(['Total Bundles in GBs','Total Bundles in MBs']);
              $chart2->dataset(' Bundles Statistics', 'bar',[$bundlesinGBs,$bundlesinMBs])
              // ->color($borderColors)
              ->backgroundcolor($fillColors);
         //   return   Carbon::parse($bundlesinMBs->created_at)->format('l');                         

              $visitor = Data_Bundles_TopUp::select(

                  DB::raw("year(created_at) as year"),

                  DB::raw("SUM(qnty) as total_click"),

                  DB::raw("SUM(created_at) as total_viewer"))
->where('shopid',$shop_id)
              ->get();


  $result[] = ['Year','Data Bundles Topup','Period'];

  foreach ($visitor as $key => $value) {

      $result[++$key] = [$value->year, (int)$value->total_click, (int)$value->total_viewer];

  }

  $ttr=json_encode($result);
 

   $data['lineChart'] = Data_Bundles_TopUp::select(\DB::raw("COUNT(*) as count"), \DB::raw("MONTHNAME(created_at) as month_name"),\DB::raw('max(created_at) as createdAt'))
  ->whereYear('created_at', date('Y'))
  ->groupBy('month_name')
  ->orderBy('createdAt')
  ->where('shopid',$shop_id)
  ->get();


        // return $data;
           





  //return $users;
       
  $today = date('Y-m-d');
            
  $query =Data_Bundles_TopUp::where('ShopID',$shop_id);
  $smscount=EloquentBuilder::to($query,request()->all())->count();
          
  $query =Data_Bundles_TopUp::where('ShopID',$shop_id)->where('status','Queued');
  $smscountsent=EloquentBuilder::to($query,request()->all())->count();
          
  $query =Data_Bundles_TopUp::where('ShopID',$shop_id)->where('status','Success');
  $smscountSuccess=EloquentBuilder::to($query,request()->all())->count();
          
  $query =Data_Bundles_TopUp::where('ShopID',$shop_id)->where('status','failed');
  $smscountfailed=EloquentBuilder::to($query,request()->all())->count();
          


  $sms =  Data_Bundles_TopUp::where('ShopID',$shop_id)->count();

    
  $borderColors = [ "#30ba35", "#f25961" ];
  $fillColors = ["#fdaf4b","#59d05d" ];
  $chart1 = new SMSChart;
  // $chart1->minimalist(true);
  $chart1->labels(['Sent','Success','Failed']);
  $sentsmscountSuccess=$smscountSuccess+$smscountsent;
  $chart1->dataset('Data Bundles stats', 'doughnut',[$smscountsent,$sentsmscountSuccess,$smscountfailed])
  // ->color($borderColors)
  ->backgroundcolor($fillColors);
                      
  $topup_datawallet  = Data_Bundles_TopUp::where('shopid',$shop_id)->where('status','Success')->where('qnty','10')->sum('qnty');
   $topup_7mb  = Data_Bundles_TopUp::where('shopid',$shop_id)->where('status','Success')->where('qnty','7')->sum('qnty');       
  //$s7mb = $topup_7mb
  
  $rt= ($topup_datawallet * 100 * 1024) + $topup_7mb;



  



              return view('bundleviews.customer-dashboard',compact('rt','data','visitor','ttr','chart1','chart2','bundlescountall','bundlesinMBs','bundlesinGBs','datawallet','wallet','contacts','users','expenditure','balance','topups','groups','expenditure_recent','topups_recent','smscount','smscountsent','smscountSuccess','smscountfailed'))->with('visitor',json_encode($result));
        }
        else{
            return abort('401');
        }
      
    }


/////////////////////////////////////////////////////////////
    //get all data
    public function getall_databundles_data()
    {
        $api_account=Auth::user()->shop_id;
        $id = Auth::user()->organization_id;
      //  $api_account = Auth::user()->api_account;
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Success')->whereDate('created_at',now()->subDays(6)->toDateString());
        $day1barsmscountSuccess=EloquentBuilder::to($query,request()->all())->count();
                
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','failed')->whereDate('created_at',now()->subDays(6)->toDateString());
        $day1barsmscountfailed=EloquentBuilder::to($query,request()->all())->count();

        $day1barsmscountSent= Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Sent')->whereDate('created_at',now()->subDays(6)->toDateString())->count();
                

        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Success')->whereDate('created_at',now()->subDays(5)->toDateString());
        $day2barsmscountSuccess=EloquentBuilder::to($query,request()->all())->count();
            
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Sent')->whereDate('created_at',now()->subDays(5)->toDateString());
        $day2barsmscountSent=EloquentBuilder::to($query,request()->all())->count();
            
            
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','failed')->whereDate('created_at',now()->subDays(5)->toDateString());
        $day2barsmscountfailed=EloquentBuilder::to($query,request()->all())->count();
                
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Success')->whereDate('created_at',now()->subDays(4)->toDateString());
        $day3barsmscountSuccess=EloquentBuilder::to($query,request()->all())->count();

                
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Sent')->whereDate('created_at',now()->subDays(4)->toDateString());
        $day3barsmscountSent=EloquentBuilder::to($query,request()->all())->count();
                
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','failed')->whereDate('created_at',now()->subDays(4)->toDateString());
        $day3barsmscountfailed=EloquentBuilder::to($query,request()->all())->count();
            
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Success')->whereDate('created_at',now()->subDays(3)->toDateString());
        $day4barsmscountSuccess=EloquentBuilder::to($query,request()->all())->count();
            
            
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Sent')->whereDate('created_at',now()->subDays(3)->toDateString());
        $day4barsmscountSent=EloquentBuilder::to($query,request()->all())->count();
            

        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','failed')->whereDate('created_at',now()->subDays(3)->toDateString());
        $day4barsmscountfailed=EloquentBuilder::to($query,request()->all())->count();
                
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Success')->whereDate('created_at',now()->subDays(2)->toDateString());
        $day5barsmscountSuccess=EloquentBuilder::to($query,request()->all())->count();
                
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Sent')->whereDate('created_at',now()->subDays(2)->toDateString());
        $day5barsmscountSent=EloquentBuilder::to($query,request()->all())->count();

        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','failed')->whereDate('created_at',now()->subDays(2)->toDateString());
        $day5barsmscountfailed=EloquentBuilder::to($query,request()->all())->count();

        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Success')->whereDate('created_at',now()->subDays(1)->toDateString());
        $day6barsmscountSuccess=EloquentBuilder::to($query,request()->all())->count();

        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Sent')->whereDate('created_at',now()->subDays(1)->toDateString());
        $day6barsmscountSent=EloquentBuilder::to($query,request()->all())->count();

        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','failed')->whereDate('created_at',now()->subDays(1)->toDateString());
        $day6barsmscountfailed=EloquentBuilder::to($query,request()->all())->count();
            
        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Success')->whereDate('created_at',now()->toDateString());
        $day7barsmscountSuccess=EloquentBuilder::to($query,request()->all())->count();

        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','Sent')->whereDate('created_at',now()->toDateString());
        $day7barsmscountSent=EloquentBuilder::to($query,request()->all())->count();


        $query =Data_Bundles_TopUp::where('ShopID',$api_account)->where('status','failed')->whereDate('created_at',now()->toDateString());
        $day7barsmscountfailed=EloquentBuilder::to($query,request()->all())->count();

                
        $successarray=array("day7"=>$day1barsmscountSuccess,"day6"=>$day2barsmscountSuccess,"day5"=>$day3barsmscountSuccess,"day4"=>$day4barsmscountSuccess,"day3"=>$day5barsmscountSuccess,"day2"=>$day6barsmscountSuccess,
        "day1"=>$day7barsmscountSuccess);

        $failedarray=array("day7"=>$day1barsmscountfailed,"day6"=>$day2barsmscountfailed,"day5"=>$day3barsmscountfailed,"day4"=>$day4barsmscountfailed,"day3"=>$day5barsmscountfailed,"day2"=>$day6barsmscountfailed,
        "day1"=>$day7barsmscountfailed);

        $sentarray=array("day7"=>$day1barsmscountSent,"day6"=>$day2barsmscountSent,"day5"=>$day3barsmscountSent,"day4"=>$day4barsmscountSent,"day3"=>$day5barsmscountSent,"day2"=>$day6barsmscountSent,
        "day1"=>$day7barsmscountSent);
            
        $alldata=array();
        $alldata['success']=$successarray;
        $alldata['failed']=$failedarray;
        $alldata['sent']=$sentarray;
        return $alldata;
    }




    


    public function databundleschart()
    {
//         $data['lineChart'] = Data_Bundles_TopUp::select(\DB::raw("COUNT(*) as count"), \DB::raw("MONTHNAME(created_at) as month_name"),\DB::raw('max(created_at) as createdAt'))
//   ->whereYear('created_at', date('Y'))
//   ->groupBy('month_name')
//   ->orderBy('createdAt')
//   ->get();
$shop_id=Auth::user()->shop_id;

$data['lineChart'] = Data_Bundles_TopUp::select(\DB::raw("COUNT(*) as count"), \DB::raw("MONTHNAME(created_at) as month_name"),\DB::raw('max(created_at) as createdAt'))
->whereYear('created_at', date('Y'))
->groupBy('month_name')
->orderBy('createdAt')
->where('shopid',$shop_id)
->where('status','g')
->get();

return response()->json($data);

    }

    
    public function databundleschartdonut()
    {
        $shop_id = Auth::user()->shop_id;
    
        $successData = Data_Bundles_TopUp::select(\DB::raw("COUNT(*) as count"), \DB::raw("MONTHNAME(created_at) as month_name"), \DB::raw('max(created_at) as createdAt'))
            ->whereYear('created_at', date('Y'))
            ->groupBy('month_name')
            ->orderBy('createdAt')
            ->where('shopid', $shop_id)
            ->where('status', 'Success')
            ->get();
    
        $failedData = Data_Bundles_TopUp::select(\DB::raw("COUNT(*) as count"), \DB::raw("MONTHNAME(created_at) as month_name"), \DB::raw('max(created_at) as createdAt'))
            ->whereYear('created_at', date('Y'))
            ->groupBy('month_name')
            ->orderBy('createdAt')
            ->where('shopid', $shop_id)
            ->where('status', 'Failed' )
            ->get();
    
        return response()->json([
            'successData' => $successData,
            'failedData' => $failedData,
        ]);
    }
    

    public function databundleslinechart()
    {
        $shop_id=Auth::user()->shop_id;
    $d4['lineChart'] = Data_Bundles_TopUp::select(\DB::raw("COUNT(*) as count"), \DB::raw("MONTHNAME(created_at) as month_name"),\DB::raw('max(created_at) as createdAt'))
    ->whereYear('created_at', date('Y'))
    ->groupBy('month_name')
    ->orderBy('createdAt')
    ->where('shopid',$shop_id)
    ->get();
    return response()->json($data);
    }



}
