<?php

namespace App\Http\Controllers\BMControllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Model;
use Auth;
use App\Models\TestAuth;
use App\Models\CustomerAuth;
use App\Http\Controllers\CustomerOtpController;
use Illuminate\Support\Facades\DB;
use DateTime;
use App\Libs\Mobisky;
use Hash;
use App\Models\CustomerUser;
use Illuminate\Support\Facades\Validator;

class LoginController extends Controller
{
    public function __construct()
    {
        //defining our middleware for this controller
        $this->middleware('guest:web',['except' => ['userlogout']]);
    }
    //function to show admin login form
    public function showLoginForm() {
        return view('auth.login');
    }
    //function to login admins
    public function login(Request $request) {
        $data=[];
       
         $this->validate($request,[
            'email' => 'required',
            'password' => 'required|min:6'
        ]);
         //check database connection and handle the exception         
     
        try{
        $db=DB::connection();   
        
        if($db){ 
            if (Auth::guard('web')->attempt(['email' => $request->email, 'password' => $request->password], $request->remember)){
        
             $customers=CustomerUser::where('cust_user_id',Auth::guard('web')->user()->cust_user_id)->get();
            
             //get username and password for mobisky sms api
             $mobiskysms=app('App\Http\Controllers\ServiceCredentialController')->mobiskySettings();
            
                 //read the values from the settings after db mapping
                 $sms_username=\Config::get('outpost.sms_username');
                 $sms_password=\Config::get('outpost.sms_password'); 

                     $smsobject=new Mobisky('twalisha','twalisha');

                     $phn="254".Auth::guard('web')->user()->cust_user_contact;
                     $otp_code=strtoupper(substr(Hash::make($smsobject->codeGenerator(6)),4,6));
                     $otp=$otp_code."0";
                     $otp_status=0;
                     $otp_created=new DateTime();
                     $cust_user_id=Auth::guard('web')->user()->cust_user_id;
                    
                    
                     $sms="Verification code: ".$otp;
                     $textstatus='test';
                     $textstatus=$smsobject->sendMessage($phn,$sms);
                    DB::table('customer_auths')->insert(['otp'=>$otp,'sms'=>'hello','otp_status'=>$otp_status,'otp_created'=>$otp_created,'customer_user_cust_user_id'=>$cust_user_id]);
                    $id = Auth::guard('web')->user()->cust_user_id; 
                    DB::table('customer_users')->where('cust_user_id',$id)->update(['cust_otp_status' => '0']);
               
                    $data=["status"=>"usersuccess","textstate"=>$textstatus];   
          } 
          else{
               $textstatus='test';
            $data=["status"=>"userfailed","textstate"=>$textstatus];
    
           } 

       
        }  
        
     
     }
    catch(\Exception $e) {

        return abort('504', 'Could not connect to the database.  Please check your configuration.'.$e);
        
    }
    //$data=["status"=>"usersuccess"]; 
    //header('Content-Type: application/json');
    return response()->json(["status"=>"usersuccess"]); 

    }


    public function userlogout()
    {
        Auth::guard('web')->logout();

        return redirect('/login');
    }

   

 
}